/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.logging.Log;

public class LogFileChannelNativeAccessor
implements ChannelNativeAccessor {
    private final FileSystemAbstraction fileSystem;
    private final NativeAccess nativeAccess;
    private final Log log;
    private final AtomicLong rotationThreshold;

    public LogFileChannelNativeAccessor(FileSystemAbstraction fileSystem, TransactionLogFilesContext context) {
        this.fileSystem = fileSystem;
        this.nativeAccess = context.getNativeAccess();
        this.log = context.getLogProvider().getLog(this.getClass());
        this.rotationThreshold = context.getRotationThreshold();
    }

    @Override
    public void adviseSequentialAccessAndKeepInCache(StoreChannel channel, long version) {
        if (channel.isOpen()) {
            NativeCallResult cacheResult;
            int fileDescriptor = this.fileSystem.getFileDescriptor(channel);
            NativeCallResult sequentialResult = this.nativeAccess.tryAdviseSequentialAccess(fileDescriptor);
            if (sequentialResult.isError()) {
                this.log.warn("Unable to advise sequential access for transaction log version: " + version + ". Error: " + sequentialResult);
            }
            if ((cacheResult = this.nativeAccess.tryAdviseToKeepInCache(fileDescriptor)).isError()) {
                this.log.warn("Unable to advise preserve data in cache for transaction log version: " + version + ". Error: " + cacheResult);
            }
        }
    }

    @Override
    public void evictFromSystemCache(StoreChannel channel, long version) {
        NativeCallResult result;
        if (channel.isOpen() && (result = this.nativeAccess.tryEvictFromCache(this.fileSystem.getFileDescriptor(channel))).isError()) {
            this.log.warn("Unable to evict transaction log from cache with version: " + version + ". Error: " + result);
        }
    }

    @Override
    public void preallocateSpace(StoreChannel storeChannel, long version) {
        int fileDescriptor = this.fileSystem.getFileDescriptor(storeChannel);
        NativeCallResult result = this.nativeAccess.tryPreallocateSpace(fileDescriptor, this.rotationThreshold.get());
        if (result.isError()) {
            this.log.warn("Error on attempt to preallocate log file version: " + version + ". Error: " + result);
        }
    }
}

