/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.LongSupplier;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.RotatableFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvents;

public interface LogFile
extends RotatableFile {
    public TransactionLogWriter getTransactionLogWriter();

    public ReadableLogChannel getReader(LogPosition var1) throws IOException;

    public ReadableLogChannel getRawReader(LogPosition var1) throws IOException;

    public ReadableLogChannel getReader(LogPosition var1, LogVersionBridge var2) throws IOException;

    public void accept(LogFileVisitor var1, LogPosition var2) throws IOException;

    public TransactionLogFileInformation getLogFileInformation();

    public PhysicalLogVersionedStoreChannel openForVersion(long var1) throws IOException;

    public PhysicalLogVersionedStoreChannel openForVersion(long var1, boolean var3) throws IOException;

    public PhysicalLogVersionedStoreChannel createLogChannelForVersion(long var1, LongSupplier var3) throws IOException;

    public long getLogVersion(Path var1);

    public Path getLogFileForVersion(long var1);

    public Path getHighestLogFile();

    public long getHighestLogVersion();

    public long getCurrentLogVersion();

    public long getLowestLogVersion();

    public LogHeader extractHeader(long var1) throws IOException;

    public boolean versionExists(long var1);

    public boolean hasAnyEntries(long var1);

    public void accept(LogVersionVisitor var1);

    public void accept(LogHeaderVisitor var1) throws IOException;

    public Path[] getMatchedFiles() throws IOException;

    public boolean forceAfterAppend(LogForceEvents var1) throws IOException;

    public void flush() throws IOException;

    @FunctionalInterface
    public static interface LogFileVisitor {
        public boolean visit(ReadableClosablePositionAwareChecksumChannel var1) throws IOException;
    }
}

