/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;

public class RestrictedSchemaWrite
implements SchemaWrite {
    private final SchemaWrite inner;
    private final SecurityContext securityContext;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;

    RestrictedSchemaWrite(SchemaWrite inner, SecurityContext securityContext, SecurityAuthorizationHandler securityAuthorizationHandler) {
        this.inner = inner;
        this.securityContext = securityContext;
        this.securityAuthorizationHandler = securityAuthorizationHandler;
    }

    public IndexProviderDescriptor indexProviderByName(String providerName) {
        return this.inner.indexProviderByName(providerName);
    }

    public IndexDescriptor indexCreate(IndexPrototype prototype) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_INDEX);
        return this.inner.indexCreate(prototype);
    }

    public IndexDescriptor indexCreate(SchemaDescriptor schema, String name) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_INDEX);
        return this.inner.indexCreate(schema, name);
    }

    public IndexDescriptor indexCreate(SchemaDescriptor schema, IndexConfig indexConfig, String name) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_INDEX);
        return this.inner.indexCreate(schema, indexConfig, name);
    }

    public IndexDescriptor indexCreate(SchemaDescriptor schema, String provider, IndexConfig indexConfig, String name) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_INDEX);
        return this.inner.indexCreate(schema, provider, indexConfig, name);
    }

    public void indexDrop(IndexDescriptor index) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_INDEX);
        this.inner.indexDrop(index);
    }

    public void indexDrop(SchemaDescriptor schema) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_INDEX);
        this.inner.indexDrop(schema);
    }

    public void indexDrop(String indexName) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_INDEX);
        this.inner.indexDrop(indexName);
    }

    public ConstraintDescriptor uniquePropertyConstraintCreate(IndexPrototype prototype) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.uniquePropertyConstraintCreate(prototype);
    }

    public ConstraintDescriptor nodeKeyConstraintCreate(IndexPrototype prototype) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.nodeKeyConstraintCreate(prototype);
    }

    public ConstraintDescriptor nodePropertyExistenceConstraintCreate(LabelSchemaDescriptor schema, String name) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.nodePropertyExistenceConstraintCreate(schema, name);
    }

    public ConstraintDescriptor relationshipPropertyExistenceConstraintCreate(RelationTypeSchemaDescriptor schema, String name) throws KernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.CREATE_CONSTRAINT);
        return this.inner.relationshipPropertyExistenceConstraintCreate(schema, name);
    }

    public void constraintDrop(SchemaDescriptor schema, ConstraintType type) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_CONSTRAINT);
        this.inner.constraintDrop(schema, type);
    }

    public void constraintDrop(String name) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_CONSTRAINT);
        this.inner.constraintDrop(name);
    }

    public void constraintDrop(ConstraintDescriptor constraint) throws SchemaKernelException {
        this.securityAuthorizationHandler.assertSchemaWrites(this.securityContext, PrivilegeAction.DROP_CONSTRAINT);
        this.inner.constraintDrop(constraint);
    }
}

