/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.util.Preconditions;

public class SystemGraphComponents {
    private final HashMap<String, SystemGraphComponent> componentMap = new HashMap();
    private final ArrayList<SystemGraphComponent> components = new ArrayList();

    public void register(SystemGraphComponent initializer) {
        this.deregister(initializer.componentName());
        this.componentMap.put(initializer.componentName(), initializer);
        this.components.add(initializer);
    }

    public void deregister(String key) {
        SystemGraphComponent removed = this.componentMap.remove(key);
        if (removed != null) {
            this.components.remove(removed);
        }
    }

    public void forEach(Consumer<SystemGraphComponent> process) {
        this.components.forEach(process);
    }

    public static String component() {
        return "system-graph";
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        return this.components.stream().map(c -> c.detect(tx)).reduce(SystemGraphComponent.Status::with).orElse(SystemGraphComponent.Status.CURRENT);
    }

    public void initializeSystemGraph(GraphDatabaseService system) {
        boolean newlyCreated;
        Preconditions.checkState((boolean)system.databaseName().equals("system"), (String)("Cannot initialize system graph on database '" + system.databaseName() + "'"));
        try (Transaction tx = system.beginTx();
             ResourceIterator nodes = tx.findNodes(SystemGraphComponent.VERSION_LABEL);){
            newlyCreated = !nodes.hasNext();
        }
        Throwable failure = null;
        for (SystemGraphComponent component : this.components) {
            try {
                component.initializeSystemGraph(system, newlyCreated);
            }
            catch (Exception e) {
                failure = (Exception)Exceptions.chain((Throwable)failure, (Throwable)e);
            }
        }
        if (failure != null) {
            throw new IllegalStateException("Failed to initialize system graph component: " + failure.getMessage(), failure);
        }
    }

    public void upgradeToCurrent(GraphDatabaseService system) throws Exception {
        Throwable failure = null;
        for (SystemGraphComponent component : this.componentsToUpgrade(system)) {
            try {
                component.upgradeToCurrent(system);
            }
            catch (Exception e) {
                failure = (Exception)Exceptions.chain((Throwable)failure, (Throwable)e);
            }
        }
        if (failure != null) {
            throw new IllegalStateException("Failed to upgrade system graph:" + failure.getMessage(), failure);
        }
    }

    private List<SystemGraphComponent> componentsToUpgrade(GraphDatabaseService system) throws Exception {
        ArrayList<SystemGraphComponent> componentsToUpgrade = new ArrayList<SystemGraphComponent>();
        SystemGraphComponent.executeWithFullAccess(system, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> this.components.stream().filter(c -> {
            SystemGraphComponent.Status status = c.detect((Transaction)tx);
            return status == SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE || status == SystemGraphComponent.Status.REQUIRES_UPGRADE || status == SystemGraphComponent.Status.UNINITIALIZED;
        }).forEach(componentsToUpgrade::add)));
        return componentsToUpgrade;
    }
}

