/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryInlinedCheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.InlinedLogTailScanner;
import org.neo4j.storageengine.api.StoreId;

public class LegacyCheckpointLogFile {
    private final InlinedLogTailScanner logTailScanner;
    private final TransactionLogFiles logFiles;
    private final TransactionLogFilesContext context;

    public LegacyCheckpointLogFile(TransactionLogFiles logFiles, TransactionLogFilesContext context) {
        this.logFiles = logFiles;
        this.context = context;
        this.logTailScanner = new InlinedLogTailScanner(logFiles, context);
    }

    public Optional<CheckpointInfo> findLatestCheckpoint() {
        return Optional.ofNullable(this.getTailInformation().lastCheckPoint);
    }

    public List<CheckpointInfo> reachableCheckpoints() throws IOException {
        LogFile logFile = this.logFiles.getLogFile();
        long highestVersion = logFile.getHighestLogVersion();
        if (highestVersion < 0L) {
            return Collections.emptyList();
        }
        long lowestVersion = logFile.getLowestLogVersion();
        long currentVersion = highestVersion;
        ArrayList<CheckpointInfo> checkpoints = new ArrayList<CheckpointInfo>();
        while (currentVersion >= lowestVersion) {
            PhysicalLogVersionedStoreChannel channel = logFile.openForVersion(currentVersion);
            try (ReadAheadLogChannel reader = new ReadAheadLogChannel((LogVersionedStoreChannel)channel, LogVersionBridge.NO_MORE_CHANNELS, this.context.getMemoryTracker());
                 LogEntryCursor logEntryCursor = new LogEntryCursor(this.context.getLogEntryReader(), (ReadableClosablePositionAwareChecksumChannel)reader);){
                LogHeader logHeader = logFile.extractHeader(currentVersion);
                StoreId storeId = logHeader.getStoreId();
                LogPosition lastLocation = reader.getCurrentPosition();
                while (logEntryCursor.next()) {
                    LogEntry logEntry = logEntryCursor.get();
                    if (logEntry instanceof LogEntryInlinedCheckPoint) {
                        checkpoints.add(new CheckpointInfo((LogEntryInlinedCheckPoint)logEntry, storeId, lastLocation));
                    }
                    lastLocation = reader.getCurrentPosition();
                }
                --currentVersion;
            }
            finally {
                if (channel == null) continue;
                channel.close();
            }
        }
        return checkpoints;
    }

    public LogTailInformation getTailInformation() {
        return this.logTailScanner.getTailInformation();
    }
}

