/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.txstate.EntityState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class DefaultPropertyCursor
extends TraceableCursor
implements PropertyCursor,
Supplier<TokenSet>,
IntSupplier {
    private static final int NODE = -2;
    private Read read;
    private final StoragePropertyCursor storeCursor;
    private final FullAccessNodeCursor securityNodeCursor;
    private final FullAccessRelationshipScanCursor securityRelCursor;
    private EntityState propertiesState;
    private Iterator<StorageProperty> txStateChangedProperties;
    private StorageProperty txStateValue;
    private AssertOpen assertOpen;
    private final CursorPool<DefaultPropertyCursor> pool;
    private AccessMode accessMode;
    private long entityReference = -1L;
    private TokenSet labels;
    private int type = -1;

    DefaultPropertyCursor(CursorPool<DefaultPropertyCursor> pool, StoragePropertyCursor storeCursor, FullAccessNodeCursor securityNodeCursor, FullAccessRelationshipScanCursor securityRelCursor) {
        this.pool = pool;
        this.storeCursor = storeCursor;
        this.securityNodeCursor = securityNodeCursor;
        this.securityRelCursor = securityRelCursor;
    }

    void initNode(long nodeReference, long reference, Read read, AssertOpen assertOpen) {
        assert (nodeReference != -1L);
        this.init(read, assertOpen);
        this.type = -2;
        this.storeCursor.initNodeProperties(reference);
        this.entityReference = nodeReference;
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getNodeState(nodeReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    void initRelationship(long relationshipReference, long reference, Read read, AssertOpen assertOpen) {
        assert (relationshipReference != -1L);
        this.init(read, assertOpen);
        this.storeCursor.initRelationshipProperties(reference);
        this.entityReference = relationshipReference;
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getRelationshipState(relationshipReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    void initEmptyRelationship(Read read, AssertOpen assertOpen) {
        this.init(read, assertOpen);
        this.storeCursor.initRelationshipProperties(-1L);
        this.entityReference = -1L;
        this.propertiesState = null;
        this.txStateChangedProperties = null;
    }

    private void init(Read read, AssertOpen assertOpen) {
        this.assertOpen = assertOpen;
        this.read = read;
        this.labels = null;
        this.type = -1;
    }

    boolean allowed() {
        if (this.isNode()) {
            this.ensureAccessMode();
            return this.accessMode.allowsReadNodeProperty((Supplier)this, this.propertyKey());
        }
        this.ensureAccessMode();
        return this.accessMode.allowsReadRelationshipProperty((IntSupplier)this, this.propertyKey());
    }

    public boolean next() {
        if (this.txStateChangedProperties != null) {
            if (this.txStateChangedProperties.hasNext()) {
                this.txStateValue = this.txStateChangedProperties.next();
                if (this.tracer != null) {
                    this.tracer.onProperty(this.propertyKey());
                }
                return true;
            }
            this.txStateChangedProperties = null;
            this.txStateValue = null;
        }
        while (this.storeCursor.next()) {
            boolean skip = this.propertiesState != null && this.propertiesState.isPropertyChangedOrRemoved(this.storeCursor.propertyKey());
            if (skip || !this.allowed()) continue;
            if (this.tracer != null) {
                this.tracer.onProperty(this.propertyKey());
            }
            return true;
        }
        return false;
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
            this.txStateValue = null;
            this.read = null;
            this.storeCursor.reset();
            this.accessMode = null;
            this.pool.accept(this);
        }
    }

    public int propertyKey() {
        if (this.txStateValue != null) {
            return this.txStateValue.propertyKeyId();
        }
        return this.storeCursor.propertyKey();
    }

    public ValueGroup propertyType() {
        if (this.txStateValue != null) {
            return this.txStateValue.value().valueGroup();
        }
        return this.storeCursor.propertyType();
    }

    public Value propertyValue() {
        if (this.txStateValue != null) {
            return this.txStateValue.value();
        }
        Value value = this.storeCursor.propertyValue();
        this.assertOpen.assertOpen();
        return value;
    }

    public boolean seekProperty(int property) {
        if (property == -1) {
            return false;
        }
        while (this.next()) {
            if (property != this.propertyKey()) continue;
            return true;
        }
        return false;
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "PropertyCursor[closed state]";
        }
        return "PropertyCursor[id=" + this.propertyKey() + ", " + this.storeCursor + " ]";
    }

    @Override
    public TokenSet get() {
        assert (this.isNode());
        if (this.labels == null) {
            this.read.singleNode(this.entityReference, this.securityNodeCursor);
            this.securityNodeCursor.next();
            this.labels = this.securityNodeCursor.labelsIgnoringTxStateSetRemove();
        }
        return this.labels;
    }

    @Override
    public int getAsInt() {
        assert (this.isRelationship());
        if (this.type < 0) {
            this.read.singleRelationship(this.entityReference, this.securityRelCursor);
            this.securityRelCursor.next();
            this.type = this.securityRelCursor.type();
        }
        return this.type;
    }

    private void ensureAccessMode() {
        if (this.accessMode == null) {
            this.accessMode = this.read.ktx.securityContext().mode();
        }
    }

    public void release() {
        this.storeCursor.close();
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
        }
        if (this.securityRelCursor != null) {
            this.securityRelCursor.close();
            this.securityRelCursor.release();
        }
    }

    private boolean isNode() {
        return this.type == -2;
    }

    private boolean isRelationship() {
        return this.type != -2;
    }
}

