/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipTraversalCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageReader;

public class DefaultPooledCursors
extends DefaultCursors
implements CursorFactory {
    private final StorageReader storageReader;
    private DefaultNodeCursor nodeCursor;
    private FullAccessNodeCursor fullAccessNodeCursor;
    private DefaultRelationshipScanCursor relationshipScanCursor;
    private FullAccessRelationshipScanCursor fullAccessRelationshipScanCursor;
    private DefaultRelationshipTraversalCursor relationshipTraversalCursor;
    private FullAccessRelationshipTraversalCursor fullAccessRelationshipTraversalCursor;
    private DefaultPropertyCursor propertyCursor;
    private FullAccessPropertyCursor fullAccessPropertyCursor;
    private DefaultNodeValueIndexCursor nodeValueIndexCursor;
    private FullAccessNodeValueIndexCursor fullAccessNodeValueIndexCursor;
    private DefaultNodeLabelIndexCursor nodeLabelIndexCursor;
    private DefaultNodeLabelIndexCursor fullAccessNodeLabelIndexCursor;
    private DefaultRelationshipIndexCursor relationshipIndexCursor;
    private DefaultRelationshipTypeIndexCursor relationshipTypeIndexCursor;

    public DefaultPooledCursors(StorageReader storageReader) {
        super(new ArrayList<DefaultCursors.CloseableStacktrace>());
        this.storageReader = storageReader;
    }

    public DefaultNodeCursor allocateNodeCursor(PageCursorTracer cursorTracer) {
        if (this.nodeCursor == null) {
            return this.trace(new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorTracer), this.storageReader.allocateNodeCursor(cursorTracer)));
        }
        try {
            DefaultNodeCursor defaultNodeCursor = this.nodeCursor;
            return defaultNodeCursor;
        }
        finally {
            this.nodeCursor = null;
        }
    }

    private void accept(DefaultNodeCursor cursor) {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
        }
        cursor.removeTracer();
        this.nodeCursor = cursor;
    }

    public FullAccessNodeCursor allocateFullAccessNodeCursor(PageCursorTracer cursorTracer) {
        if (this.fullAccessNodeCursor == null) {
            return this.trace(new FullAccessNodeCursor(this::acceptFullAccess, this.storageReader.allocateNodeCursor(cursorTracer)));
        }
        try {
            FullAccessNodeCursor fullAccessNodeCursor = this.fullAccessNodeCursor;
            return fullAccessNodeCursor;
        }
        finally {
            this.fullAccessNodeCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeCursor cursor) {
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessNodeCursor = (FullAccessNodeCursor)cursor;
    }

    public DefaultRelationshipScanCursor allocateRelationshipScanCursor(PageCursorTracer cursorTracer) {
        if (this.relationshipScanCursor == null) {
            return this.trace(new DefaultRelationshipScanCursor(this::accept, this.storageReader.allocateRelationshipScanCursor(cursorTracer), new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorTracer), this.storageReader.allocateNodeCursor(cursorTracer))));
        }
        try {
            DefaultRelationshipScanCursor defaultRelationshipScanCursor = this.relationshipScanCursor;
            return defaultRelationshipScanCursor;
        }
        finally {
            this.relationshipScanCursor = null;
        }
    }

    private void accept(DefaultRelationshipScanCursor cursor) {
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
        }
        cursor.removeTracer();
        this.relationshipScanCursor = cursor;
    }

    public RelationshipScanCursor allocateFullAccessRelationshipScanCursor(PageCursorTracer cursorTracer) {
        if (this.fullAccessRelationshipScanCursor == null) {
            return this.trace(new FullAccessRelationshipScanCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipScanCursor(cursorTracer)));
        }
        try {
            FullAccessRelationshipScanCursor fullAccessRelationshipScanCursor = this.fullAccessRelationshipScanCursor;
            return fullAccessRelationshipScanCursor;
        }
        finally {
            this.fullAccessRelationshipScanCursor = null;
        }
    }

    private void acceptFullAccess(DefaultRelationshipScanCursor cursor) {
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessRelationshipScanCursor = (FullAccessRelationshipScanCursor)cursor;
    }

    public DefaultRelationshipTraversalCursor allocateRelationshipTraversalCursor(PageCursorTracer cursorTracer) {
        if (this.relationshipTraversalCursor == null) {
            return this.trace(new DefaultRelationshipTraversalCursor(this::accept, this.storageReader.allocateRelationshipTraversalCursor(cursorTracer), new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorTracer), this.storageReader.allocateNodeCursor(cursorTracer))));
        }
        try {
            DefaultRelationshipTraversalCursor defaultRelationshipTraversalCursor = this.relationshipTraversalCursor;
            return defaultRelationshipTraversalCursor;
        }
        finally {
            this.relationshipTraversalCursor = null;
        }
    }

    void accept(DefaultRelationshipTraversalCursor cursor) {
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
        }
        cursor.removeTracer();
        this.relationshipTraversalCursor = cursor;
    }

    public RelationshipTraversalCursor allocateFullAccessRelationshipTraversalCursor(PageCursorTracer cursorTracer) {
        if (this.fullAccessRelationshipTraversalCursor == null) {
            return this.trace(new FullAccessRelationshipTraversalCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipTraversalCursor(cursorTracer)));
        }
        try {
            FullAccessRelationshipTraversalCursor fullAccessRelationshipTraversalCursor = this.fullAccessRelationshipTraversalCursor;
            return fullAccessRelationshipTraversalCursor;
        }
        finally {
            this.fullAccessRelationshipTraversalCursor = null;
        }
    }

    private void acceptFullAccess(DefaultRelationshipTraversalCursor cursor) {
        if (this.fullAccessRelationshipTraversalCursor != null) {
            this.fullAccessRelationshipTraversalCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessRelationshipTraversalCursor = (FullAccessRelationshipTraversalCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultPropertyCursor allocatePropertyCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        if (this.propertyCursor == null) {
            FullAccessNodeCursor nodeCursor = new FullAccessNodeCursor(this::acceptFullAccess, this.storageReader.allocateNodeCursor(cursorTracer));
            FullAccessRelationshipScanCursor relCursor = new FullAccessRelationshipScanCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipScanCursor(cursorTracer));
            return this.trace(new DefaultPropertyCursor(this::accept, this.storageReader.allocatePropertyCursor(cursorTracer, memoryTracker), nodeCursor, relCursor));
        }
        try {
            DefaultPropertyCursor defaultPropertyCursor = this.propertyCursor;
            return defaultPropertyCursor;
        }
        finally {
            this.propertyCursor = null;
        }
    }

    private void accept(DefaultPropertyCursor cursor) {
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
        }
        cursor.removeTracer();
        this.propertyCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullAccessPropertyCursor allocateFullAccessPropertyCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        if (this.fullAccessPropertyCursor == null) {
            return this.trace(new FullAccessPropertyCursor(this::acceptFullAccess, this.storageReader.allocatePropertyCursor(cursorTracer, memoryTracker)));
        }
        try {
            FullAccessPropertyCursor fullAccessPropertyCursor = this.fullAccessPropertyCursor;
            return fullAccessPropertyCursor;
        }
        finally {
            this.fullAccessPropertyCursor = null;
        }
    }

    private void acceptFullAccess(DefaultPropertyCursor cursor) {
        if (this.fullAccessPropertyCursor != null) {
            this.fullAccessPropertyCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessPropertyCursor = (FullAccessPropertyCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultNodeValueIndexCursor allocateNodeValueIndexCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        if (this.nodeValueIndexCursor == null) {
            return this.trace(new DefaultNodeValueIndexCursor(this::accept, new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorTracer), this.storageReader.allocateNodeCursor(cursorTracer)), memoryTracker));
        }
        try {
            DefaultNodeValueIndexCursor defaultNodeValueIndexCursor = this.nodeValueIndexCursor;
            return defaultNodeValueIndexCursor;
        }
        finally {
            this.nodeValueIndexCursor = null;
        }
    }

    private void accept(DefaultNodeValueIndexCursor cursor) {
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.nodeValueIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullAccessNodeValueIndexCursor allocateFullAccessNodeValueIndexCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        if (this.fullAccessNodeValueIndexCursor == null) {
            return this.trace(new FullAccessNodeValueIndexCursor(this::acceptFullAccess, memoryTracker));
        }
        try {
            FullAccessNodeValueIndexCursor fullAccessNodeValueIndexCursor = this.fullAccessNodeValueIndexCursor;
            return fullAccessNodeValueIndexCursor;
        }
        finally {
            this.fullAccessNodeValueIndexCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeValueIndexCursor cursor) {
        if (this.fullAccessNodeValueIndexCursor != null) {
            this.fullAccessNodeValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessNodeValueIndexCursor = (FullAccessNodeValueIndexCursor)cursor;
    }

    public DefaultNodeLabelIndexCursor allocateNodeLabelIndexCursor(PageCursorTracer cursorTracer) {
        if (this.nodeLabelIndexCursor == null) {
            return this.trace(new DefaultNodeLabelIndexCursor(this::accept, new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorTracer), this.storageReader.allocateNodeCursor(cursorTracer))));
        }
        try {
            DefaultNodeLabelIndexCursor defaultNodeLabelIndexCursor = this.nodeLabelIndexCursor;
            return defaultNodeLabelIndexCursor;
        }
        finally {
            this.nodeLabelIndexCursor = null;
        }
    }

    private void accept(DefaultNodeLabelIndexCursor cursor) {
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
        }
        cursor.removeTracer();
        this.nodeLabelIndexCursor = cursor;
    }

    public DefaultNodeLabelIndexCursor allocateFullAccessNodeLabelIndexCursor(PageCursorTracer cursorTracer) {
        if (this.fullAccessNodeLabelIndexCursor == null) {
            return this.trace(new FullAccessNodeLabelIndexCursor(this::acceptFullAccess));
        }
        try {
            DefaultNodeLabelIndexCursor defaultNodeLabelIndexCursor = this.fullAccessNodeLabelIndexCursor;
            return defaultNodeLabelIndexCursor;
        }
        finally {
            this.fullAccessNodeLabelIndexCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeLabelIndexCursor cursor) {
        if (this.fullAccessNodeLabelIndexCursor != null) {
            this.fullAccessNodeLabelIndexCursor.release();
        }
        this.fullAccessNodeLabelIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipIndexCursor allocateRelationshipIndexCursor(PageCursorTracer cursorTracer) {
        if (this.relationshipIndexCursor == null) {
            DefaultNodeCursor nodeCursor = new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorTracer), this.storageReader.allocateNodeCursor(cursorTracer));
            DefaultRelationshipScanCursor relationshipScanCursor = new DefaultRelationshipScanCursor(this::accept, this.storageReader.allocateRelationshipScanCursor(cursorTracer), nodeCursor);
            return this.trace(new DefaultRelationshipIndexCursor(this::accept, relationshipScanCursor));
        }
        try {
            DefaultRelationshipIndexCursor defaultRelationshipIndexCursor = this.relationshipIndexCursor;
            return defaultRelationshipIndexCursor;
        }
        finally {
            this.relationshipIndexCursor = null;
        }
    }

    private void accept(DefaultRelationshipIndexCursor cursor) {
        if (this.relationshipIndexCursor != null) {
            this.relationshipIndexCursor.release();
        }
        cursor.removeTracer();
        this.relationshipIndexCursor = cursor;
    }

    public DefaultRelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor() {
        if (this.relationshipTypeIndexCursor == null) {
            return this.trace(new DefaultRelationshipTypeIndexCursor(this::accept));
        }
        try {
            DefaultRelationshipTypeIndexCursor defaultRelationshipTypeIndexCursor = this.relationshipTypeIndexCursor;
            return defaultRelationshipTypeIndexCursor;
        }
        finally {
            this.relationshipTypeIndexCursor = null;
        }
    }

    private void accept(DefaultRelationshipTypeIndexCursor cursor) {
        if (this.relationshipTypeIndexCursor != null) {
            this.relationshipTypeIndexCursor.release();
        }
        cursor.removeTracer();
        this.relationshipTypeIndexCursor = cursor;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
            this.nodeCursor = null;
        }
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
            this.fullAccessNodeCursor = null;
        }
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
            this.relationshipScanCursor = null;
        }
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
            this.fullAccessRelationshipScanCursor = null;
        }
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
            this.relationshipTraversalCursor = null;
        }
        if (this.fullAccessRelationshipTraversalCursor != null) {
            this.fullAccessRelationshipTraversalCursor.release();
            this.fullAccessRelationshipTraversalCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
            this.propertyCursor = null;
        }
        if (this.fullAccessPropertyCursor != null) {
            this.fullAccessPropertyCursor.release();
            this.fullAccessPropertyCursor = null;
        }
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
            this.nodeValueIndexCursor = null;
        }
        if (this.fullAccessNodeValueIndexCursor != null) {
            this.fullAccessNodeValueIndexCursor.release();
            this.fullAccessNodeValueIndexCursor = null;
        }
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
            this.nodeLabelIndexCursor = null;
        }
        if (this.fullAccessNodeLabelIndexCursor != null) {
            this.fullAccessNodeLabelIndexCursor.release();
            this.fullAccessNodeLabelIndexCursor = null;
        }
        if (this.relationshipIndexCursor != null) {
            this.relationshipIndexCursor.release();
            this.relationshipIndexCursor = null;
        }
    }
}

