/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.CollectingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

public abstract class NativeIndexPopulator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndex<KEY, VALUE>
implements IndexPopulator,
ConsistencyCheckable {
    public static final byte BYTE_FAILED = 0;
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_POPULATING = 2;
    private final KEY treeKey;
    private final VALUE treeValue;
    private final UniqueIndexSampler uniqueSampler;
    private final Consumer<PageCursor> additionalHeaderWriter;
    private ConflictDetectingValueMerger<KEY, VALUE, Value[]> mainConflictDetector;
    private ConflictDetectingValueMerger<KEY, VALUE, Value[]> updatesConflictDetector;
    private byte[] failureBytes;
    private boolean dropped;
    private boolean closed;

    NativeIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY, VALUE> layout, IndexDescriptor descriptor, Consumer<PageCursor> additionalHeaderWriter, GBPTree.Monitor treeMonitor) {
        super(databaseIndexContext, layout, indexFiles, descriptor, treeMonitor);
        this.treeKey = (NativeIndexKey)((Object)layout.newKey());
        this.treeValue = layout.newValue();
        this.additionalHeaderWriter = additionalHeaderWriter;
        this.uniqueSampler = descriptor.isUnique() ? new UniqueIndexSampler() : null;
    }

    abstract NativeIndexReader<KEY, VALUE> newReader();

    public synchronized void create() {
        this.assertNotDropped();
        this.assertNotClosed();
        this.indexFiles.clear();
        NativeIndexHeaderWriter headerWriter = new NativeIndexHeaderWriter(2, this.additionalHeaderWriter);
        this.instantiateTree(RecoveryCleanupWorkCollector.immediate(), headerWriter);
        this.mainConflictDetector = new ThrowingConflictDetector(!this.descriptor.isUnique());
        this.updatesConflictDetector = new ThrowingConflictDetector(true);
    }

    public synchronized void drop() {
        try {
            if (this.tree != null) {
                this.tree.setDeleteOnClose(true);
            }
            this.closeTree();
            this.indexFiles.clear();
        }
        finally {
            this.dropped = true;
            this.closed = true;
        }
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates, PageCursorTracer cursorTracer) throws IndexEntryConflictException {
        this.processUpdates(updates, this.mainConflictDetector, cursorTracer);
    }

    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor, PageCursorTracer cursorTracer) {
        return this.newPopulatingUpdater(cursorTracer);
    }

    IndexUpdater newPopulatingUpdater(PageCursorTracer cursorTracer) {
        Object updater = new CollectingIndexUpdater(updates -> this.processUpdates(updates, this.updatesConflictDetector, cursorTracer));
        if (this.descriptor.isUnique()) {
            updater = new DeferredConflictCheckingIndexUpdater((IndexUpdater)updater, this::newReader, this.descriptor, cursorTracer);
        }
        return updater;
    }

    public synchronized void close(boolean populationCompletedSuccessfully, PageCursorTracer cursorTracer) {
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        try {
            this.assertNotDropped();
            if (populationCompletedSuccessfully) {
                this.assertPopulatorOpen();
                this.flushTreeAndMarkAs((byte)1, cursorTracer);
            } else if (this.failureBytes != null) {
                this.ensureTreeInstantiated();
                this.markTreeAsFailed(cursorTracer);
            }
        }
        finally {
            this.closeTree();
            this.closed = true;
        }
    }

    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    public void includeSample(IndexEntryUpdate<?> update) {
        if (this.descriptor.isUnique()) {
            this.updateUniqueSample(update);
        }
    }

    public IndexSample sample(PageCursorTracer cursorTracer) {
        if (this.descriptor.isUnique()) {
            return this.uniqueSampler.result();
        }
        return this.buildNonUniqueIndexSample(cursorTracer);
    }

    void flushTreeAndMarkAs(byte state, PageCursorTracer cursorTracer) {
        this.tree.checkpoint(IOLimiter.UNLIMITED, (Consumer)new NativeIndexHeaderWriter(state, this.additionalHeaderWriter), cursorTracer);
    }

    IndexSample buildNonUniqueIndexSample(PageCursorTracer cursorTracer) {
        return new FullScanNonUniqueIndexSampler(this.tree, this.layout).sample(cursorTracer);
    }

    private void markTreeAsFailed(PageCursorTracer cursorTracer) {
        Preconditions.checkState((this.failureBytes != null ? 1 : 0) != 0, (String)"markAsFailed hasn't been called, populator not actually failed?");
        this.tree.checkpoint(IOLimiter.UNLIMITED, (Consumer)new FailureHeaderWriter(this.failureBytes), cursorTracer);
    }

    private void processUpdates(Iterable<? extends IndexEntryUpdate<?>> indexEntryUpdates, ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetector, PageCursorTracer cursorTracer) throws IndexEntryConflictException {
        try (Writer writer = this.tree.writer(cursorTracer);){
            for (IndexEntryUpdate<?> indexEntryUpdate : indexEntryUpdates) {
                NativeIndexUpdater.processUpdate(this.treeKey, this.treeValue, indexEntryUpdate, writer, conflictDetector);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void updateUniqueSample(IndexEntryUpdate<?> update) {
        switch (update.updateMode()) {
            case ADDED: {
                this.uniqueSampler.increment(1L);
                break;
            }
            case REMOVED: {
                this.uniqueSampler.increment(-1L);
                break;
            }
            case CHANGED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported update mode type:" + update.updateMode());
            }
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void ensureTreeInstantiated() {
        if (this.tree == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.ignore(), GBPTree.NO_HEADER_WRITER);
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }
}

