/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.updater;

import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public class UpdateCountingIndexUpdater
implements IndexUpdater {
    private final IndexStatisticsStore indexStatisticsStore;
    private final long indexId;
    private final IndexUpdater delegate;
    private long updates;

    public UpdateCountingIndexUpdater(IndexStatisticsStore indexStatisticsStore, long indexId, IndexUpdater delegate) {
        this.indexStatisticsStore = indexStatisticsStore;
        this.indexId = indexId;
        this.delegate = delegate;
    }

    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
        this.delegate.process(update);
        ++this.updates;
    }

    public void close() throws IndexEntryConflictException {
        this.delegate.close();
        this.indexStatisticsStore.incrementIndexUpdates(this.indexId, this.updates);
    }
}

