/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.store.MultipleUnderlyingStorageExceptions;

class IndexUpdaterMap
implements AutoCloseable {
    private final IndexUpdateMode indexUpdateMode;
    private final IndexMap indexMap;
    private final Map<IndexDescriptor, IndexUpdater> updaterMap;

    IndexUpdaterMap(IndexMap indexMap, IndexUpdateMode indexUpdateMode) {
        this.indexUpdateMode = indexUpdateMode;
        this.indexMap = indexMap;
        this.updaterMap = new HashMap<IndexDescriptor, IndexUpdater>();
    }

    IndexUpdater getUpdater(IndexDescriptor descriptor, PageCursorTracer cursorTracer) {
        IndexProxy indexProxy;
        IndexUpdater updater = this.updaterMap.get(descriptor);
        if (null == updater && null != (indexProxy = this.indexMap.getIndexProxy(descriptor))) {
            updater = indexProxy.newUpdater(this.indexUpdateMode, cursorTracer);
            this.updaterMap.put(descriptor, updater);
        }
        return updater;
    }

    @Override
    public void close() throws UnderlyingStorageException {
        HashSet<Pair> exceptions = null;
        for (Map.Entry<IndexDescriptor, IndexUpdater> updaterEntry : this.updaterMap.entrySet()) {
            IndexUpdater updater = updaterEntry.getValue();
            try {
                updater.close();
            }
            catch (UncheckedIOException | IndexEntryConflictException e) {
                if (null == exceptions) {
                    exceptions = new HashSet<Pair>();
                }
                exceptions.add(Pair.of((Object)updaterEntry.getKey(), (Object)new UnderlyingStorageException(e)));
            }
        }
        this.clear();
        if (null != exceptions) {
            throw new MultipleUnderlyingStorageExceptions(exceptions);
        }
    }

    public void clear() {
        this.updaterMap.clear();
    }

    public boolean isEmpty() {
        return this.updaterMap.isEmpty();
    }

    public int size() {
        return this.updaterMap.size();
    }
}

