/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;

public class DefaultRecoveryService
implements RecoveryService {
    private final RecoveryStartInformationProvider recoveryStartInformationProvider;
    private final StorageEngine storageEngine;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private final LogVersionRepository logVersionRepository;
    private final Log log;

    DefaultRecoveryService(StorageEngine storageEngine, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository, LogFiles logFiles, RecoveryStartInformationProvider.Monitor monitor, Log log) {
        this.storageEngine = storageEngine;
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.logVersionRepository = logVersionRepository;
        this.log = log;
        this.recoveryStartInformationProvider = new RecoveryStartInformationProvider(logFiles, monitor);
    }

    @Override
    public RecoveryStartInformation getRecoveryStartInformation() {
        return this.recoveryStartInformationProvider.get();
    }

    @Override
    public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode, PageCursorTracer cursorTracer) {
        return new RecoveryVisitor(this.storageEngine, mode, cursorTracer);
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getTransactions(position);
    }

    @Override
    public TransactionCursor getTransactionsInReverseOrder(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getTransactionsInReverseOrder(position);
    }

    @Override
    public void transactionsRecovered(CommittedTransactionRepresentation lastRecoveredTransaction, LogPosition lastRecoveredTransactionPosition, LogPosition positionAfterLastRecoveredTransaction, LogPosition checkpointPosition, boolean missingLogs, PageCursorTracer cursorTracer) {
        if (missingLogs) {
            long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
            long logVersion = lastClosedTransaction[1];
            this.log.warn("Recovery detected that transaction logs were missing. Resetting offset of last closed transaction to point to the head of %d transaction log file.", new Object[]{logVersion});
            this.transactionIdStore.resetLastClosedTransaction(lastClosedTransaction[0], logVersion, 64L, true, cursorTracer);
            this.logVersionRepository.setCurrentLogVersion(logVersion, cursorTracer);
            long checkpointLogVersion = this.logVersionRepository.getCheckpointLogVersion();
            if (checkpointLogVersion < 0L) {
                this.log.warn("Recovery detected that checkpoint log version is invalid. Resetting version to start from the beginning. Current recorded version: %d. New version: 0.", new Object[]{checkpointLogVersion});
                this.logVersionRepository.setCheckpointLogVersion(0L, cursorTracer);
            }
            return;
        }
        if (lastRecoveredTransaction != null) {
            LogEntryCommit commitEntry = lastRecoveredTransaction.getCommitEntry();
            this.transactionIdStore.setLastCommittedAndClosedTransactionId(commitEntry.getTxId(), lastRecoveredTransaction.getChecksum(), commitEntry.getTimeWritten(), lastRecoveredTransactionPosition.getByteOffset(), lastRecoveredTransactionPosition.getLogVersion(), cursorTracer);
        } else {
            long lastClosedTransactionId = this.transactionIdStore.getLastClosedTransactionId();
            this.log.warn("Recovery detected that transaction logs tail can't be trusted. Resetting offset of last closed transaction to point to the last recoverable log position: " + positionAfterLastRecoveredTransaction);
            this.transactionIdStore.resetLastClosedTransaction(lastClosedTransactionId, positionAfterLastRecoveredTransaction.getLogVersion(), positionAfterLastRecoveredTransaction.getByteOffset(), false, cursorTracer);
        }
        this.logVersionRepository.setCurrentLogVersion(positionAfterLastRecoveredTransaction.getLogVersion(), cursorTracer);
        this.logVersionRepository.setCheckpointLogVersion(checkpointPosition.getLogVersion(), cursorTracer);
    }

    static class RecoveryVisitor
    implements RecoveryApplier {
        private final StorageEngine storageEngine;
        private final TransactionApplicationMode mode;
        private final PageCursorTracer cursorTracer;

        RecoveryVisitor(StorageEngine storageEngine, TransactionApplicationMode mode, PageCursorTracer cursorTracer) {
            this.storageEngine = storageEngine;
            this.mode = mode;
            this.cursorTracer = cursorTracer;
        }

        public boolean visit(CommittedTransactionRepresentation transaction) throws Exception {
            TransactionRepresentation txRepresentation = transaction.getTransactionRepresentation();
            long txId = transaction.getCommitEntry().getTxId();
            TransactionToApply tx = new TransactionToApply(txRepresentation, txId, this.cursorTracer);
            tx.commitment(Commitment.NO_COMMITMENT, txId);
            tx.logPosition(transaction.getStartEntry().getStartPosition());
            this.storageEngine.apply((CommandsToApply)tx, this.mode);
            return false;
        }

        @Override
        public void close() {
        }
    }
}

