/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.community.LockNotFoundException;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.LockTransaction;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.LockWaitEvent;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.VisibleForTesting;

@VisibleForTesting
public class RWLock {
    private final LockResource resource;
    private final LinkedList<LockRequest> waitingThreadList = new LinkedList();
    private final Map<LockTransaction, TxLockElement> txLockElementMap = new HashMap<LockTransaction, TxLockElement>();
    private final RagManager ragManager;
    private final SystemNanoClock clock;
    private final long lockAcquisitionTimeoutNano;
    private int totalReadCount;
    private int totalWriteCount;
    private int marked;

    RWLock(LockResource resource, RagManager ragManager, SystemNanoClock clock, long lockAcquisitionTimeoutNano) {
        this.resource = resource;
        this.ragManager = ragManager;
        this.clock = clock;
        this.lockAcquisitionTimeoutNano = lockAcquisitionTimeoutNano;
    }

    public LockResource resource() {
        return this.resource;
    }

    synchronized void mark() {
        this.marked = Math.incrementExact(this.marked);
    }

    private void unmark() {
        this.marked = MathUtil.decrementExactNotPastZero((int)this.marked);
    }

    synchronized boolean isMarked() {
        return this.marked > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean acquireReadLock(LockTracer tracer, LockTransaction tx) throws DeadlockDetectedException {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        LockRequest lockRequest = null;
        LockWaitEvent waitEvent = null;
        boolean addLockRequest = true;
        try {
            tle.incrementRequests();
            Thread currentThread = Thread.currentThread();
            long waitStartNano = this.clock.nanos();
            while (!tle.isTerminated() && this.totalWriteCount > tle.writeCount) {
                this.assertNotExpired(waitStartNano);
                this.ragManager.checkWaitOn(this, tx);
                if (addLockRequest) {
                    lockRequest = new LockRequest(tle, LockType.SHARED, currentThread, this.clock);
                    this.waitingThreadList.addFirst(lockRequest);
                }
                if (waitEvent == null) {
                    waitEvent = tracer.waitForLock(LockType.SHARED, this.resource.resourceType(), tx.getTransactionId(), new long[]{this.resource.resourceId()});
                }
                addLockRequest = this.waitUninterruptedly(waitStartNano);
                this.ragManager.stopWaitOn(this, tx);
            }
            if (!tle.isTerminated()) {
                this.registerReadLockAcquired(tx, tle);
                boolean bl = true;
                return bl;
            }
            if (tle.requests == 1 && tle.isFree()) {
                this.txLockElementMap.remove(tx);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
            }
            this.cleanupWaitingListRequests(lockRequest, tle, addLockRequest);
            Thread.interrupted();
            tle.decrementRequests();
            this.unmark();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean tryAcquireReadLock(LockTransaction tx) {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            if (tle.isTerminated() || this.totalWriteCount > tle.writeCount) {
                boolean bl = false;
                return bl;
            }
            this.registerReadLockAcquired(tx, tle);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unmark();
        }
    }

    synchronized void releaseReadLock(LockTransaction tx) throws LockNotFoundException {
        TxLockElement tle = this.getLockElement(tx);
        if (tle.readCount == 0) {
            throw new LockNotFoundException(tx + " don't have readLock");
        }
        this.totalReadCount = MathUtil.decrementExactNotPastZero((int)this.totalReadCount);
        tle.readCount = MathUtil.decrementExactNotPastZero((int)tle.readCount);
        if (tle.isFree()) {
            this.ragManager.lockReleased(this, tx);
            if (tle.hasNoRequests()) {
                this.txLockElementMap.remove(tx);
            }
        }
        if (!this.waitingThreadList.isEmpty()) {
            LockRequest lockRequest = this.waitingThreadList.getLast();
            if (lockRequest.lockType == LockType.EXCLUSIVE) {
                if (this.totalReadCount == lockRequest.element.readCount) {
                    this.waitingThreadList.removeLast();
                    lockRequest.waitingThread.interrupt();
                } else {
                    ListIterator<LockRequest> listItr = this.waitingThreadList.listIterator(this.waitingThreadList.lastIndexOf(lockRequest));
                    while (listItr.hasPrevious()) {
                        lockRequest = listItr.previous();
                        if (lockRequest.lockType == LockType.EXCLUSIVE && this.totalReadCount == lockRequest.element.readCount) {
                            listItr.remove();
                            lockRequest.waitingThread.interrupt();
                            break;
                        }
                        if (lockRequest.lockType != LockType.SHARED) continue;
                        listItr.remove();
                        lockRequest.waitingThread.interrupt();
                    }
                }
            } else if (this.totalWriteCount == 0) {
                this.waitingThreadList.removeLast();
                lockRequest.waitingThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean acquireWriteLock(LockTracer tracer, LockTransaction tx) throws DeadlockDetectedException {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        LockRequest lockRequest = null;
        LockWaitEvent waitEvent = null;
        boolean addLockRequest = true;
        try {
            tle.incrementRequests();
            Thread currentThread = Thread.currentThread();
            long waitStartNano = this.clock.nanos();
            while (!(tle.isTerminated() || this.totalWriteCount <= tle.writeCount && this.totalReadCount <= tle.readCount)) {
                this.assertNotExpired(waitStartNano);
                this.ragManager.checkWaitOn(this, tx);
                if (addLockRequest) {
                    lockRequest = new LockRequest(tle, LockType.EXCLUSIVE, currentThread, this.clock);
                    this.waitingThreadList.addFirst(lockRequest);
                }
                if (waitEvent == null) {
                    waitEvent = tracer.waitForLock(LockType.EXCLUSIVE, this.resource.resourceType(), tx.getTransactionId(), new long[]{this.resource.resourceId()});
                }
                addLockRequest = this.waitUninterruptedly(waitStartNano);
                this.ragManager.stopWaitOn(this, tx);
            }
            if (!tle.isTerminated()) {
                this.registerWriteLockAcquired(tx, tle);
                boolean bl = true;
                return bl;
            }
            if (tle.requests == 1 && tle.isFree()) {
                this.txLockElementMap.remove(tx);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
            }
            this.cleanupWaitingListRequests(lockRequest, tle, addLockRequest);
            Thread.interrupted();
            tle.decrementRequests();
            this.unmark();
        }
    }

    private boolean waitUninterruptedly(long waitStartNano) {
        boolean addLockRequest;
        try {
            if (this.lockAcquisitionTimeoutNano > 0L) {
                this.assertNotExpired(waitStartNano);
                this.wait(TimeUnit.NANOSECONDS.toMillis(Math.abs(this.lockAcquisitionTimeoutNano - this.clock.nanos() + waitStartNano)));
            } else {
                this.wait();
            }
            addLockRequest = false;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            addLockRequest = true;
        }
        return addLockRequest;
    }

    private void cleanupWaitingListRequests(LockRequest lockRequest, TxLockElement lockElement, boolean addLockRequest) {
        if (lockRequest != null && (lockElement.isTerminated() || !addLockRequest)) {
            this.waitingThreadList.remove(lockRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean tryAcquireWriteLock(LockTransaction tx) {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            if (tle.isTerminated() || this.totalWriteCount > tle.writeCount || this.totalReadCount > tle.readCount) {
                boolean bl = false;
                return bl;
            }
            this.registerWriteLockAcquired(tx, tle);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unmark();
        }
    }

    synchronized void releaseWriteLock(LockTransaction tx) throws LockNotFoundException {
        TxLockElement tle = this.getLockElement(tx);
        if (tle.writeCount == 0) {
            throw new LockNotFoundException(tx + " don't have writeLock");
        }
        this.totalWriteCount = MathUtil.decrementExactNotPastZero((int)this.totalWriteCount);
        tle.writeCount = MathUtil.decrementExactNotPastZero((int)tle.writeCount);
        if (tle.isFree()) {
            this.ragManager.lockReleased(this, tx);
            if (tle.hasNoRequests()) {
                this.txLockElementMap.remove(tx);
            }
        }
        if (this.totalWriteCount == 0 && !this.waitingThreadList.isEmpty()) {
            LockRequest lockRequest;
            do {
                lockRequest = this.waitingThreadList.removeLast();
                lockRequest.waitingThread.interrupt();
            } while (lockRequest.lockType != LockType.EXCLUSIVE && !this.waitingThreadList.isEmpty());
        }
    }

    synchronized int getWriteCount() {
        return this.totalWriteCount;
    }

    synchronized int getReadCount() {
        return this.totalReadCount;
    }

    synchronized int getWaitingThreadsCount() {
        return this.waitingThreadList.size();
    }

    public synchronized String describe() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append(" Total lock count: readCount=").append(this.totalReadCount).append(" writeCount=").append(this.totalWriteCount).append(" for ").append(this.resource).append("\n").append("Waiting list:\n");
        Iterator wElements = this.waitingThreadList.iterator();
        while (wElements.hasNext()) {
            LockRequest lockRequest = (LockRequest)wElements.next();
            sb.append('[').append(lockRequest.waitingThread).append('(').append(lockRequest.element.readCount).append("r,").append(lockRequest.element.writeCount).append("w),").append(lockRequest.lockType).append("]\n");
            if (!wElements.hasNext()) continue;
            sb.append(',');
        }
        sb.append("Locking transactions:\n");
        for (TxLockElement tle : this.txLockElementMap.values()) {
            sb.append(tle.tx).append('(').append(tle.readCount).append("r,").append(tle.writeCount).append("w)\n");
        }
        return sb.toString();
    }

    synchronized long maxWaitTime() {
        long max = 0L;
        for (LockRequest thread : this.waitingThreadList) {
            if (thread.since >= max) continue;
            max = thread.since;
        }
        return TimeUnit.NANOSECONDS.toMillis(this.clock.nanos() - max);
    }

    synchronized void terminateLockRequestsForLockTransaction(LockTransaction lockTransaction) {
        TxLockElement lockElement = this.txLockElementMap.get(lockTransaction);
        if (lockElement != null && !lockElement.isTerminated()) {
            lockElement.setTerminated(true);
            for (LockRequest lockRequest : this.waitingThreadList) {
                if (!lockRequest.element.tx.equals(lockTransaction)) continue;
                lockRequest.waitingThread.interrupt();
            }
        }
    }

    public String toString() {
        return "RWLock[" + this.resource + ", hash=" + this.hashCode() + "]";
    }

    private void registerReadLockAcquired(LockTransaction tx, TxLockElement tle) {
        this.registerLockAcquired(tx, tle);
        this.totalReadCount = Math.incrementExact(this.totalReadCount);
        tle.readCount = Math.incrementExact(tle.readCount);
    }

    private void registerWriteLockAcquired(LockTransaction tx, TxLockElement tle) {
        this.registerLockAcquired(tx, tle);
        this.totalWriteCount = Math.incrementExact(this.totalWriteCount);
        tle.writeCount = Math.incrementExact(tle.writeCount);
    }

    private void registerLockAcquired(LockTransaction tx, TxLockElement tle) {
        if (tle.isFree()) {
            this.ragManager.lockAcquired(this, tx);
        }
    }

    private TxLockElement getLockElement(LockTransaction tx) {
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            throw new LockNotFoundException("No transaction lock element found for " + tx);
        }
        return tle;
    }

    private void assertTransaction(LockTransaction tx) {
        if (tx == null) {
            throw new IllegalArgumentException();
        }
    }

    private TxLockElement getOrCreateLockElement(LockTransaction tx) {
        this.assertTransaction(tx);
        return this.txLockElementMap.computeIfAbsent(tx, TxLockElement::new);
    }

    private void assertNotExpired(long waitStartNano) {
        long timeoutNano = this.lockAcquisitionTimeoutNano;
        if (timeoutNano > 0L && this.clock.nanos() - waitStartNano >= timeoutNano) {
            throw new LockAcquisitionTimeoutException(this.resource.resourceType(), this.resource.resourceId(), timeoutNano);
        }
    }

    synchronized int getTxLockElementCount() {
        return this.txLockElementMap.size();
    }

    synchronized LongSet transactionIds() {
        return LongSets.immutable.ofAll(this.txLockElementMap.values().stream().mapToLong(TxLockElement::owningTransactionId));
    }

    private static class LockRequest {
        private final TxLockElement element;
        private final LockType lockType;
        private final Thread waitingThread;
        private final long since;

        LockRequest(TxLockElement element, LockType lockType, Thread thread, SystemNanoClock clock) {
            this.element = element;
            this.lockType = lockType;
            this.waitingThread = thread;
            this.since = clock.nanos();
        }
    }

    private static class TxLockElement {
        private final LockTransaction tx;
        private int readCount;
        private int writeCount;
        private int requests;
        private boolean terminated;

        TxLockElement(LockTransaction tx) {
            this.tx = tx;
        }

        void incrementRequests() {
            this.requests = Math.incrementExact(this.requests);
        }

        void decrementRequests() {
            this.requests = MathUtil.decrementExactNotPastZero((int)this.requests);
        }

        boolean hasNoRequests() {
            return this.requests == 0;
        }

        boolean isFree() {
            return this.readCount == 0 && this.writeCount == 0;
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public void setTerminated(boolean terminated) {
            this.terminated = terminated;
        }

        public long owningTransactionId() {
            return this.tx.getTransactionId();
        }
    }
}

