/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;

public class DatabaseIndexContext {
    final PageCache pageCache;
    final FileSystemAbstraction fileSystem;
    final IndexProvider.Monitor monitor;
    final boolean readOnly;

    private DatabaseIndexContext(PageCache pageCache, FileSystemAbstraction fileSystem, IndexProvider.Monitor monitor, boolean readOnly) {
        this.pageCache = pageCache;
        this.fileSystem = fileSystem;
        this.monitor = monitor;
        this.readOnly = readOnly;
    }

    public static Builder builder(PageCache pageCache, FileSystemAbstraction fileSystem) {
        return new Builder(pageCache, fileSystem);
    }

    public static class Builder {
        private final PageCache pageCache;
        private final FileSystemAbstraction fileSystem;
        private IndexProvider.Monitor monitor;
        private boolean readOnly;

        private Builder(PageCache pageCache, FileSystemAbstraction fileSystem) {
            this.pageCache = pageCache;
            this.fileSystem = fileSystem;
            this.monitor = IndexProvider.Monitor.EMPTY;
            this.readOnly = false;
        }

        public Builder withReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder withMonitor(IndexProvider.Monitor monitor) {
            this.monitor = monitor;
            return this;
        }

        public DatabaseIndexContext build() {
            return new DatabaseIndexContext(this.pageCache, this.fileSystem, this.monitor, this.readOnly);
        }
    }
}

