/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingUnifiedMap;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.kernel.impl.util.collection.LongProbeTable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class HeapTrackingOrderedAppendMap<K, V>
extends DefaultCloseListenable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingOrderedAppendMap.class);
    private static final int INITIAL_CHUNK_SIZE = 32;
    private static final int MAX_CHUNK_SIZE = 8192;
    private final MemoryTracker scopedMemoryTracker;
    private HeapTrackingUnifiedMap<K, V> map;
    private Chunk first;
    private Chunk current;

    public static <K, V> HeapTrackingOrderedAppendMap<K, V> createOrderedMap(MemoryTracker memoryTracker) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + LongProbeTable.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        return new HeapTrackingOrderedAppendMap<K, V>(scopedMemoryTracker);
    }

    private HeapTrackingOrderedAppendMap(MemoryTracker scopedMemoryTracker) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.map = HeapTrackingCollections.newMap((MemoryTracker)scopedMemoryTracker);
        this.current = this.first = new Chunk(32, scopedMemoryTracker);
    }

    public V getIfAbsentPutWithMemoryTracker(K key, Function<MemoryTracker, ? extends V> function) {
        return (V)this.map.getIfAbsentPutWith(key, (Function & Serializable)p -> {
            MemoryTracker memoryTracker = this.scopedMemoryTracker;
            Object value = p.valueOf((Object)memoryTracker);
            this.addToBuffer(key, value);
            return value;
        }, function);
    }

    public V getIfAbsentPutWithMemoryTracker2(K key, Function2<K, MemoryTracker, ? extends V> function) {
        Object value = this.map.get(key);
        if (value != null) {
            return (V)value;
        }
        Object newValue = function.value(key, (Object)this.scopedMemoryTracker);
        this.map.put(key, newValue);
        this.addToBuffer(key, newValue);
        return (V)newValue;
    }

    public V get(K key) {
        return (V)this.map.get(key);
    }

    public void put(K key, V value) {
        this.addToBuffer(key, value);
        if (this.map.put(key, value) != null) {
            throw new UnsupportedOperationException("Replacing an existing value is not supported.");
        }
    }

    public void forEachValue(Procedure<? super V> p) {
        Chunk chunk = this.first;
        while (chunk != null) {
            for (int i = 1; i < chunk.cursor; i += 2) {
                p.accept(chunk.elements[i]);
            }
            chunk = chunk.next;
        }
    }

    public Iterator<Map.Entry<K, V>> autoClosingEntryIterator() {
        this.map.close();
        this.map = null;
        return new AutoClosingTransientEntryIterator();
    }

    public MemoryTracker scopedMemoryTracker() {
        return this.scopedMemoryTracker;
    }

    public void closeInternal() {
        this.map = null;
        this.first = null;
        this.current = null;
        this.scopedMemoryTracker.close();
    }

    public boolean isClosed() {
        return this.first == null;
    }

    public void addToBuffer(Object key, Object value) {
        if (!this.current.add(key, value)) {
            Chunk newChunk;
            int newChunkSize = this.grow(this.current.elements.length);
            this.current.next = newChunk = new Chunk(newChunkSize, this.scopedMemoryTracker);
            this.current = newChunk;
            this.current.add(key, value);
        }
    }

    @VisibleForTesting
    int numberOfChunks() {
        int i = 0;
        Chunk chunk = this.first;
        while (chunk != null) {
            chunk = chunk.next;
            ++i;
        }
        return i;
    }

    private int grow(int size) {
        if (size == 8192) {
            return size;
        }
        int newSize = size << 1;
        if (newSize <= 0 || newSize > 8192) {
            return 8192;
        }
        return newSize;
    }

    private static class Chunk {
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Chunk.class);
        private final Object[] elements;
        private Chunk next;
        private int cursor;

        Chunk(int size, MemoryTracker memoryTracker) {
            memoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.shallowSizeOfObjectArray((int)size));
            this.elements = new Object[size];
        }

        boolean add(Object key, Object value) {
            if (this.cursor < this.elements.length) {
                this.elements[this.cursor] = key;
                this.elements[this.cursor + 1] = value;
                this.cursor += 2;
                return true;
            }
            return false;
        }
    }

    private class AutoClosingTransientEntryIterator
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        private Chunk chunk;
        private Chunk nextChunk;
        private int index;
        private int nextIndex;

        private AutoClosingTransientEntryIterator() {
            this.chunk = this.nextChunk = HeapTrackingOrderedAppendMap.this.first;
            HeapTrackingOrderedAppendMap.this.first = null;
            HeapTrackingOrderedAppendMap.this.current = null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextChunk == null || this.nextIndex >= this.nextChunk.cursor) {
                HeapTrackingOrderedAppendMap.this.close();
                return false;
            }
            return true;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.nextChunk == null) {
                throw new NoSuchElementException();
            }
            this.index = this.nextIndex;
            this.chunk = this.nextChunk;
            this.nextIndex += 2;
            if (this.nextIndex >= this.nextChunk.cursor) {
                this.nextChunk = this.nextChunk.next;
                this.nextIndex = 0;
            }
            return this;
        }

        @Override
        public K getKey() {
            return this.chunk.elements[this.index];
        }

        @Override
        public V getValue() {
            return this.chunk.elements[this.index + 1];
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)o;
                return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object key = this.getKey();
            Object value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
    }
}

