/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.neo4j.hashing.HashFunction;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.values.storable.Value;

public final class ResourceIds {
    private static final HashFunction HASH_40 = HashFunction.incrementalXXH64();
    private static final long HASH_40_INIT = HASH_40.initialise(81985529216486895L);

    private ResourceIds() {
    }

    public static long indexEntryResourceId(long labelId, IndexQuery.ExactPredicate ... predicates) {
        return ResourceIds.indexEntryResourceId_4_x(labelId, predicates);
    }

    public static long schemaNameResourceId(String schemaName) {
        long hash = HASH_40_INIT;
        hash = schemaName.chars().asLongStream().reduce(hash, (arg_0, arg_1) -> ((HashFunction)HASH_40).update(arg_0, arg_1));
        return HASH_40.finalise(hash);
    }

    static long indexEntryResourceId_4_x(long labelId, IndexQuery.ExactPredicate[] predicates) {
        long hash = HASH_40_INIT;
        hash = HASH_40.update(hash, labelId);
        for (IndexQuery.ExactPredicate predicate : predicates) {
            int propertyKeyId = predicate.propertyKeyId();
            hash = HASH_40.update(hash, (long)propertyKeyId);
            Value value = predicate.value();
            hash = value.updateHash(HASH_40, hash);
        }
        return HASH_40.finalise(hash);
    }
}

