/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.index.schema.BlockEntryReader;
import org.neo4j.kernel.impl.index.schema.ReadableChannelPageCursor;

public class BlockReader<KEY, VALUE>
implements Closeable {
    private final StoreChannel channel;
    private final FileSystemAbstraction fs;
    private final Path path;
    private final Layout<KEY, VALUE> layout;

    BlockReader(FileSystemAbstraction fs, Path path, Layout<KEY, VALUE> layout) throws IOException {
        this.fs = fs;
        this.path = path;
        this.layout = layout;
        this.channel = fs.read(path);
    }

    BlockEntryReader<KEY, VALUE> nextBlock(ScopedBuffer blockBuffer) throws IOException {
        long position = this.channel.position();
        if (position >= this.channel.size()) {
            return null;
        }
        StoreChannel blockChannel = this.fs.read(this.path);
        blockChannel.position(position);
        ReadableChannelPageCursor pageCursor = new ReadableChannelPageCursor((ReadableChannel)new ReadAheadChannel(blockChannel, blockBuffer.getBuffer()));
        BlockEntryReader<KEY, VALUE> blockEntryReader = new BlockEntryReader<KEY, VALUE>(pageCursor, this.layout);
        long blockSize = blockEntryReader.blockSize();
        this.channel.position(position + blockSize);
        return blockEntryReader;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

