/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.zone.ZoneRulesProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.os.OsBeanUtil;

public enum SystemDiagnostics implements DiagnosticsProvider
{
    SYSTEM_MEMORY("System memory information"){

        public void dump(DiagnosticsLogger logger) {
            SystemDiagnostics.logBytes(logger, "Total Physical memory: ", OsBeanUtil.getTotalPhysicalMemory());
            SystemDiagnostics.logBytes(logger, "Free Physical memory: ", OsBeanUtil.getFreePhysicalMemory());
            SystemDiagnostics.logBytes(logger, "Committed virtual memory: ", OsBeanUtil.getCommittedVirtualMemory());
            SystemDiagnostics.logBytes(logger, "Total swap space: ", OsBeanUtil.getTotalSwapSpace());
            SystemDiagnostics.logBytes(logger, "Free swap space: ", OsBeanUtil.getFreeSwapSpace());
        }
    }
    ,
    JAVA_MEMORY("JVM memory information"){

        public void dump(DiagnosticsLogger logger) {
            logger.log("Free  memory: " + ByteUnit.bytesToString((long)Runtime.getRuntime().freeMemory()));
            logger.log("Total memory: " + ByteUnit.bytesToString((long)Runtime.getRuntime().totalMemory()));
            logger.log("Max   memory: " + ByteUnit.bytesToString((long)Runtime.getRuntime().maxMemory()));
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                logger.log("Garbage Collector: " + gc.getName() + ": " + Arrays.toString(gc.getMemoryPoolNames()));
            }
            for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                MemoryUsage usage = pool.getUsage();
                logger.log(String.format("Memory Pool: %s (%s): committed=%s, used=%s, max=%s, threshold=%s", new Object[]{pool.getName(), pool.getType(), usage == null ? "?" : ByteUnit.bytesToString((long)usage.getCommitted()), usage == null ? "?" : ByteUnit.bytesToString((long)usage.getUsed()), usage == null ? "?" : ByteUnit.bytesToString((long)usage.getMax()), pool.isUsageThresholdSupported() ? ByteUnit.bytesToString((long)pool.getUsageThreshold()) : "?"}));
            }
        }
    }
    ,
    OPERATING_SYSTEM("Operating system information"){

        public void dump(DiagnosticsLogger logger) {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            logger.log(String.format("Operating System: %s; version: %s; arch: %s; cpus: %s", os.getName(), os.getVersion(), os.getArch(), os.getAvailableProcessors()));
            SystemDiagnostics.logLong(logger, "Max number of file descriptors: ", OsBeanUtil.getMaxFileDescriptors());
            SystemDiagnostics.logLong(logger, "Number of open file descriptors: ", OsBeanUtil.getOpenFileDescriptors());
            logger.log("Process id: " + runtime.getName());
            logger.log("Byte order: " + ByteOrder.nativeOrder());
            logger.log("Local timezone: " + this.getLocalTimeZone());
        }

        private String getLocalTimeZone() {
            return ZoneId.systemDefault().getId();
        }
    }
    ,
    JAVA_VIRTUAL_MACHINE("JVM information"){

        public void dump(DiagnosticsLogger logger) {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            logger.log("VM Name: " + runtime.getVmName());
            logger.log("VM Vendor: " + runtime.getVmVendor());
            logger.log("VM Version: " + runtime.getVmVersion());
            CompilationMXBean compiler = ManagementFactory.getCompilationMXBean();
            logger.log("JIT compiler: " + (compiler == null ? "unknown" : compiler.getName()));
            logger.log("VM Arguments: " + runtime.getInputArguments());
        }
    }
    ,
    CLASSPATH("Java classpath"){

        public void dump(DiagnosticsLogger logger) {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            Collection<String> classpath = runtime.isBootClassPathSupported() ? this.buildClassPath(((Object)((Object)this)).getClass().getClassLoader(), Map.of("bootstrap", runtime.getBootClassPath(), "classpath", runtime.getClassPath())) : this.buildClassPath(((Object)((Object)this)).getClass().getClassLoader(), Map.of("classpath", runtime.getClassPath()));
            for (String path : classpath) {
                logger.log(path);
            }
        }

        private Collection<String> buildClassPath(ClassLoader loader, Map<String, String> classPaths) {
            HashMap<String, String> paths = new HashMap<String, String>();
            Set<Map.Entry<String, String>> entries = classPaths.entrySet();
            for (Map.Entry<String, String> classPathEntry : entries) {
                String[] splittedClassPath;
                String classPathType = classPathEntry.getKey();
                String[] stringArray = splittedClassPath = classPathEntry.getValue().split(File.pathSeparator);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String entry = stringArray[i];
                    String canonicalEntry = SystemDiagnostics.canonicalize(entry);
                    paths.merge(canonicalEntry, classPathType, (k, v) -> v + " + " + classPathType);
                }
            }
            int level = 0;
            while (loader != null) {
                if (loader instanceof URLClassLoader) {
                    URLClassLoader urls = (URLClassLoader)loader;
                    URL[] classLoaderUrls = urls.getURLs();
                    if (classLoaderUrls != null) {
                        for (URL url : classLoaderUrls) {
                            if (!"file".equalsIgnoreCase(url.getProtocol())) continue;
                            String type = "loader." + level;
                            paths.merge(url.toString(), type, (k, v) -> k + " + " + type);
                        }
                    } else {
                        paths.put(loader.toString(), "<ClassLoader unexpectedly has null URL array>");
                    }
                }
                loader = loader.getParent();
                ++level;
            }
            ArrayList<String> result = new ArrayList<String>(paths.size());
            for (Map.Entry path : paths.entrySet()) {
                result.add(" [" + (String)path.getValue() + "] " + (String)path.getKey());
            }
            return result;
        }
    }
    ,
    LIBRARY_PATH("Library path"){

        public void dump(DiagnosticsLogger logger) {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            for (String path : runtime.getLibraryPath().split(File.pathSeparator)) {
                logger.log(SystemDiagnostics.canonicalize(path));
            }
        }
    }
    ,
    SYSTEM_PROPERTIES("System properties"){

        public void dump(DiagnosticsLogger logger) {
            for (Object property : System.getProperties().keySet()) {
                String key;
                if (!(property instanceof String) || (key = (String)property).startsWith("java.") || key.startsWith("os.") || key.endsWith(".boot.class.path") || key.equals("line.separator")) continue;
                logger.log(key + " = " + System.getProperty(key));
            }
        }
    }
    ,
    TIMEZONE_DATABASE("(IANA) TimeZone database version"){

        public void dump(DiagnosticsLogger logger) {
            HashMap<String, Integer> versions = new HashMap<String, Integer>();
            for (String tz : ZoneRulesProvider.getAvailableZoneIds()) {
                for (String version : ZoneRulesProvider.getVersions(tz).keySet()) {
                    versions.compute(version, (key, value) -> value == null ? 1 : value + 1);
                }
            }
            Object[] sorted = versions.keySet().toArray(new String[0]);
            Arrays.sort(sorted);
            for (Object tz : sorted) {
                logger.log(String.format("  TimeZone version: %s (available for %d zone identifiers)", tz, versions.get(tz)));
            }
        }
    }
    ,
    NETWORK("Network information"){

        public void dump(DiagnosticsLogger logger) {
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface iface = networkInterfaces.nextElement();
                    logger.log(String.format("Interface %s:", iface.getDisplayName()));
                    Enumeration<InetAddress> addresses = iface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        String hostAddress = address.getHostAddress();
                        logger.log(String.format("    address: %s", hostAddress));
                    }
                }
            }
            catch (SocketException e) {
                logger.log("ERROR: failed to inspect network interfaces and addresses: " + e.getMessage());
            }
        }
    }
    ,
    NATIVE_ACCESSOR("Native access information"){

        public void dump(DiagnosticsLogger logger) {
            NativeAccess nativeAccess = NativeAccessProvider.getNativeAccess();
            logger.log("Native access details: " + nativeAccess.describe());
        }
    }
    ,
    CONTAINER("Container heuristics"){

        public void dump(DiagnosticsLogger logger) {
            logger.log("Docker: " + this.isRunningInDocker());
            logger.log("LXC: " + this.isRunningInLxc());
            logger.log("Kubernetes: " + this.isRunningInKubernetes());
        }

        private boolean isRunningInDocker() {
            boolean bl;
            block8: {
                Stream<String> stream = Files.lines(Paths.get("/proc/1/cgroup", new String[0]));
                try {
                    bl = stream.anyMatch(line -> line.contains("/docker"));
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                stream.close();
            }
            return bl;
        }

        private boolean isRunningInLxc() {
            return "lxc".equals(System.getProperty("container"));
        }

        private boolean isRunningInKubernetes() {
            return System.getProperty("KUBERNETES_SERVICE_HOST") != null;
        }
    };

    private final String name;

    private SystemDiagnostics(String name) {
        this.name = name;
    }

    public String getDiagnosticsName() {
        return this.name;
    }

    private static String canonicalize(String path) {
        try {
            return FileUtils.getCanonicalFile((Path)Path.of(path, new String[0])).toAbsolutePath().toString();
        }
        catch (UncheckedIOException e) {
            return Path.of(path, new String[0]).toAbsolutePath().toString();
        }
    }

    private static void logBytes(DiagnosticsLogger logger, String message, long value) {
        if (value != -1L) {
            logger.log(message + ByteUnit.bytesToString((long)value));
        }
    }

    private static void logLong(DiagnosticsLogger logger, String message, long value) {
        if (value != -1L) {
            logger.log(message + value);
        }
    }
}

