/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Queue;
import org.jctools.queues.MpmcArrayQueue;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class CachingOffHeapBlockAllocator
implements OffHeapBlockAllocator {
    private final long maxCacheableBlockSize;
    private volatile boolean released;
    private final Queue<OffHeapBlockAllocator.MemoryBlock>[] caches;

    @VisibleForTesting
    public CachingOffHeapBlockAllocator() {
        this(ByteUnit.kibiBytes((long)512L), 128);
    }

    public CachingOffHeapBlockAllocator(long maxCacheableBlockSize, int maxCachedBlocks) {
        Preconditions.requirePositive((int)maxCachedBlocks);
        this.maxCacheableBlockSize = Preconditions.requirePowerOfTwo((long)maxCacheableBlockSize);
        int numOfCaches = Numbers.log2floor((long)maxCacheableBlockSize) + 1;
        this.caches = new Queue[numOfCaches];
        for (int i = 0; i < this.caches.length; ++i) {
            this.caches[i] = new MpmcArrayQueue(maxCachedBlocks);
        }
    }

    @Override
    public OffHeapBlockAllocator.MemoryBlock allocate(long size, MemoryTracker tracker) {
        Preconditions.requirePositive((long)size);
        Preconditions.checkState((!this.released ? 1 : 0) != 0, (String)"Allocator is already released");
        if (this.notCacheable(size)) {
            return this.allocateNew(size, tracker);
        }
        Queue<OffHeapBlockAllocator.MemoryBlock> cache = this.caches[Numbers.log2floor((long)size)];
        OffHeapBlockAllocator.MemoryBlock block = cache.poll();
        if (block == null) {
            block = this.allocateNew(size, tracker);
        } else {
            tracker.allocateNative(block.size);
        }
        return block;
    }

    @Override
    public void free(OffHeapBlockAllocator.MemoryBlock block, MemoryTracker tracker) {
        if (this.released || this.notCacheable(block.size)) {
            this.doFree(block, tracker);
            return;
        }
        Queue<OffHeapBlockAllocator.MemoryBlock> cache = this.caches[Numbers.log2floor((long)block.size)];
        if (!cache.offer(block)) {
            this.doFree(block, tracker);
            return;
        }
        if (this.released && cache.remove(block)) {
            this.doFree(block, tracker);
            return;
        }
        tracker.releaseNative(block.size);
    }

    @Override
    public void release() {
        this.released = true;
        for (Queue<OffHeapBlockAllocator.MemoryBlock> cache : this.caches) {
            OffHeapBlockAllocator.MemoryBlock block;
            while ((block = cache.poll()) != null) {
                UnsafeUtil.free((long)block.addr, (long)block.size, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            }
        }
    }

    @VisibleForTesting
    void doFree(OffHeapBlockAllocator.MemoryBlock block, MemoryTracker tracker) {
        UnsafeUtil.free((long)block.addr, (long)block.size, (MemoryTracker)tracker);
    }

    @VisibleForTesting
    OffHeapBlockAllocator.MemoryBlock allocateNew(long size, MemoryTracker tracker) {
        long addr = UnsafeUtil.allocateMemory((long)size, (MemoryTracker)tracker);
        return new OffHeapBlockAllocator.MemoryBlock(addr, size);
    }

    private boolean notCacheable(long size) {
        return !Numbers.isPowerOfTwo((long)size) || size > this.maxCacheableBlockSize;
    }
}

