/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.rotation;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.monitoring.Health;
import org.neo4j.util.VisibleForTesting;

public class LogRotationImpl
implements LogRotation {
    private final Clock clock;
    private final LogRotationMonitor monitor;
    private final LogFiles logFiles;
    private final Health databaseHealth;
    private final LogFile logFile;
    private long lastRotationCompleted;

    public LogRotationImpl(LogFiles logFiles, Clock clock, Health databaseHealth, LogRotationMonitor monitor) {
        this.clock = clock;
        this.monitor = monitor;
        this.logFiles = logFiles;
        this.databaseHealth = databaseHealth;
        this.logFile = logFiles.getLogFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rotateLogIfNeeded(LogAppendEvent logAppendEvent) throws IOException {
        if (this.logFile.rotationNeeded()) {
            LogFile logFile = this.logFile;
            synchronized (logFile) {
                if (this.logFile.rotationNeeded()) {
                    this.doRotate(logAppendEvent);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void rotateLogFile(LogAppendEvent logAppendEvent) throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.doRotate(logAppendEvent);
        }
    }

    private void doRotate(LogAppendEvent logAppendEvent) throws IOException {
        try (LogRotateEvent rotateEvent = logAppendEvent.beginLogRotate();){
            long currentVersion = this.logFiles.getHighestLogVersion();
            this.databaseHealth.assertHealthy(IOException.class);
            long startTimeMillis = this.clock.millis();
            this.monitor.startRotation(currentVersion);
            File newLogFile = this.logFile.rotate();
            long lastTransactionId = this.logFiles.getLogFileInformation().committingEntryId();
            long millisSinceLastRotation = this.lastRotationCompleted == 0L ? 0L : startTimeMillis - this.lastRotationCompleted;
            this.lastRotationCompleted = this.clock.millis();
            long rotationElapsedTime = this.lastRotationCompleted - startTimeMillis;
            rotateEvent.rotationCompleted(rotationElapsedTime);
            this.monitor.finishLogRotation(newLogFile, currentVersion, lastTransactionId, rotationElapsedTime, millisSinceLastRotation);
        }
    }
}

