/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.impl.newapi.NodeWithPropertyValues;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class TxStateIndexChanges {
    private static final AddedWithValuesAndRemoved EMPTY_ADDED_AND_REMOVED_WITH_VALUES = new AddedWithValuesAndRemoved(Collections.emptyList(), (LongSet)LongSets.immutable.empty());
    private static final AddedAndRemoved EMPTY_ADDED_AND_REMOVED = new AddedAndRemoved((LongIterable)LongLists.immutable.empty(), (LongSet)LongSets.immutable.empty());

    TxStateIndexChanges() {
    }

    static AddedAndRemoved indexUpdatesForScan(ReadableTransactionState txState, IndexDescriptor descriptor, IndexOrder indexOrder) {
        return TxStateIndexChanges.indexUpdatesForScanAndFilter(txState, descriptor, null, indexOrder);
    }

    static AddedWithValuesAndRemoved indexUpdatesWithValuesForScan(ReadableTransactionState txState, IndexDescriptor descriptor, IndexOrder indexOrder) {
        return TxStateIndexChanges.indexUpdatesWithValuesScanAndFilter(txState, descriptor, null, indexOrder);
    }

    static AddedAndRemoved indexUpdatesForSuffixOrContains(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery query, IndexOrder indexOrder) {
        if (descriptor.schema().getPropertyIds().length != 1) {
            throw new IllegalStateException("Suffix and contains queries on multiple property queries should have been rewritten as existence and filter before now");
        }
        return TxStateIndexChanges.indexUpdatesForScanAndFilter(txState, descriptor, query, indexOrder);
    }

    static AddedWithValuesAndRemoved indexUpdatesWithValuesForSuffixOrContains(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery query, IndexOrder indexOrder) {
        if (descriptor.schema().getPropertyIds().length != 1) {
            throw new IllegalStateException("Suffix and contains queries on multiple property queries should have been rewritten as existence and filter before now");
        }
        return TxStateIndexChanges.indexUpdatesWithValuesScanAndFilter(txState, descriptor, query, indexOrder);
    }

    static AddedAndRemoved indexUpdatesForSeek(ReadableTransactionState txState, IndexDescriptor descriptor, ValueTuple values) {
        UnmodifiableMap updates = txState.getIndexUpdates(descriptor.schema());
        if (updates != null) {
            LongDiffSets indexUpdatesForSeek = (LongDiffSets)updates.get((Object)values);
            return indexUpdatesForSeek == null ? EMPTY_ADDED_AND_REMOVED : new AddedAndRemoved((LongIterable)LongLists.mutable.ofAll((LongIterable)indexUpdatesForSeek.getAdded()), indexUpdatesForSeek.getRemoved());
        }
        return EMPTY_ADDED_AND_REMOVED;
    }

    static AddedAndRemoved indexUpdatesForRangeSeek(ReadableTransactionState txState, IndexDescriptor descriptor, Value[] equalityPrefix, IndexQuery.RangePredicate<?> predicate, IndexOrder indexOrder) {
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EMPTY_ADDED_AND_REMOVED;
        }
        int size = descriptor.schema().getPropertyIds().length;
        RangeFilterValues rangeFilter = predicate == null ? RangeFilterValues.fromExists(size, equalityPrefix) : RangeFilterValues.fromRange(size, equalityPrefix, predicate);
        MutableLongList added = LongLists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        NavigableMap inRange = sortedUpdates.subMap(rangeFilter.lower, true, rangeFilter.upper, true);
        for (Map.Entry entry : inRange.entrySet()) {
            ValueTuple values = (ValueTuple)entry.getKey();
            Value rangeKey = values.valueAt(equalityPrefix.length);
            LongDiffSets diffForSpecificValue = (LongDiffSets)entry.getValue();
            boolean allowed = rangeFilter.allowedEntry(rangeKey, equalityPrefix.length);
            if (!allowed || predicate != null && !predicate.isRegularOrder() && !predicate.acceptsValue(rangeKey)) continue;
            added.addAll((LongIterable)diffForSpecificValue.getAdded());
            removed.addAll((LongIterable)diffForSpecificValue.getRemoved());
        }
        return new AddedAndRemoved((LongIterable)(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added), (LongSet)removed);
    }

    static AddedWithValuesAndRemoved indexUpdatesWithValuesForRangeSeek(ReadableTransactionState txState, IndexDescriptor descriptor, Value[] equalityPrefix, IndexQuery.RangePredicate<?> predicate, IndexOrder indexOrder) {
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EMPTY_ADDED_AND_REMOVED_WITH_VALUES;
        }
        int size = descriptor.schema().getPropertyIds().length;
        RangeFilterValues rangeFilter = predicate == null ? RangeFilterValues.fromExists(size, equalityPrefix) : RangeFilterValues.fromRange(size, equalityPrefix, predicate);
        MutableList added = Lists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        NavigableMap inRange = sortedUpdates.subMap(rangeFilter.lower, true, rangeFilter.upper, true);
        for (Map.Entry entry : inRange.entrySet()) {
            ValueTuple values = (ValueTuple)entry.getKey();
            Value rangeKey = values.valueAt(equalityPrefix.length);
            Value[] valuesArray = values.getValues();
            LongDiffSets diffForSpecificValue = (LongDiffSets)entry.getValue();
            boolean allowed = rangeFilter.allowedEntry(rangeKey, equalityPrefix.length);
            if (!allowed || predicate != null && !predicate.isRegularOrder() && !predicate.acceptsValue(rangeKey)) continue;
            diffForSpecificValue.getAdded().each((LongProcedure & Serializable)nodeId -> added.add((Object)new NodeWithPropertyValues(nodeId, valuesArray)));
            removed.addAll((LongIterable)diffForSpecificValue.getRemoved());
        }
        return new AddedWithValuesAndRemoved((Iterable<NodeWithPropertyValues>)(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added), (LongSet)removed);
    }

    static AddedAndRemoved indexUpdatesForRangeSeekByPrefix(ReadableTransactionState txState, IndexDescriptor descriptor, Value[] equalityPrefix, TextValue prefix, IndexOrder indexOrder) {
        Map.Entry entry;
        Value key;
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EMPTY_ADDED_AND_REMOVED;
        }
        int size = descriptor.schema().getPropertyIds().length;
        ValueTuple floor = TxStateIndexChanges.getCompositeValueTuple(size, equalityPrefix, (Value)prefix, true);
        ValueTuple maxString = TxStateIndexChanges.getCompositeValueTuple(size, equalityPrefix, Values.MAX_STRING, false);
        MutableLongList added = LongLists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        Iterator iterator = sortedUpdates.subMap(floor, maxString).entrySet().iterator();
        while (iterator.hasNext() && (key = (entry = iterator.next()).getKey().valueAt(equalityPrefix.length)).valueGroup() == ValueGroup.TEXT && ((TextValue)key).startsWith(prefix)) {
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            added.addAll((LongIterable)diffSets.getAdded());
            removed.addAll((LongIterable)diffSets.getRemoved());
        }
        return new AddedAndRemoved((LongIterable)(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added), (LongSet)removed);
    }

    static AddedWithValuesAndRemoved indexUpdatesWithValuesForRangeSeekByPrefix(ReadableTransactionState txState, IndexDescriptor descriptor, Value[] equalityPrefix, TextValue prefix, IndexOrder indexOrder) {
        Map.Entry entry;
        ValueTuple key;
        Value prefixKey;
        NavigableMap sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EMPTY_ADDED_AND_REMOVED_WITH_VALUES;
        }
        int keySize = descriptor.schema().getPropertyIds().length;
        ValueTuple floor = TxStateIndexChanges.getCompositeValueTuple(keySize, equalityPrefix, (Value)prefix, true);
        ValueTuple maxString = TxStateIndexChanges.getCompositeValueTuple(keySize, equalityPrefix, Values.MAX_STRING, false);
        MutableList added = Lists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        Iterator iterator = sortedUpdates.subMap(floor, maxString).entrySet().iterator();
        while (iterator.hasNext() && (prefixKey = (key = (entry = iterator.next()).getKey()).valueAt(equalityPrefix.length)).valueGroup() == ValueGroup.TEXT && ((TextValue)prefixKey).startsWith(prefix)) {
            LongDiffSets diffSets = (LongDiffSets)entry.getValue();
            Value[] values = key.getValues();
            diffSets.getAdded().each((LongProcedure & Serializable)nodeId -> added.add((Object)new NodeWithPropertyValues(nodeId, values)));
            removed.addAll((LongIterable)diffSets.getRemoved());
        }
        return new AddedWithValuesAndRemoved((Iterable<NodeWithPropertyValues>)(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added), (LongSet)removed);
    }

    private static AddedAndRemoved indexUpdatesForScanAndFilter(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery filter, IndexOrder indexOrder) {
        Map<ValueTuple, ? extends LongDiffSets> updates = TxStateIndexChanges.getUpdates(txState, descriptor, indexOrder);
        if (updates == null) {
            return EMPTY_ADDED_AND_REMOVED;
        }
        MutableLongList added = LongLists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        for (Map.Entry<ValueTuple, ? extends LongDiffSets> entry : updates.entrySet()) {
            ValueTuple key = entry.getKey();
            if (filter != null && !filter.acceptsValue(key.valueAt(0))) continue;
            LongDiffSets diffSet = entry.getValue();
            added.addAll((LongIterable)diffSet.getAdded());
            removed.addAll((LongIterable)diffSet.getRemoved());
        }
        return new AddedAndRemoved((LongIterable)(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added), (LongSet)removed);
    }

    private static AddedWithValuesAndRemoved indexUpdatesWithValuesScanAndFilter(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery filter, IndexOrder indexOrder) {
        Map<ValueTuple, ? extends LongDiffSets> updates = TxStateIndexChanges.getUpdates(txState, descriptor, indexOrder);
        if (updates == null) {
            return EMPTY_ADDED_AND_REMOVED_WITH_VALUES;
        }
        MutableList added = Lists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        for (Map.Entry<ValueTuple, ? extends LongDiffSets> entry : updates.entrySet()) {
            ValueTuple key = entry.getKey();
            if (filter != null && !filter.acceptsValue(key.valueAt(0))) continue;
            Value[] values = key.getValues();
            LongDiffSets diffSet = entry.getValue();
            diffSet.getAdded().each((LongProcedure & Serializable)nodeId -> added.add((Object)new NodeWithPropertyValues(nodeId, values)));
            removed.addAll((LongIterable)diffSet.getRemoved());
        }
        return new AddedWithValuesAndRemoved((Iterable<NodeWithPropertyValues>)(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added), (LongSet)removed);
    }

    private static Map<ValueTuple, ? extends LongDiffSets> getUpdates(ReadableTransactionState txState, IndexDescriptor descriptor, IndexOrder indexOrder) {
        return indexOrder == IndexOrder.NONE ? txState.getIndexUpdates(descriptor.schema()) : txState.getSortedIndexUpdates(descriptor.schema());
    }

    private static ValueTuple getCompositeValueTuple(int size, Value[] equalityValues, Value nextValue, boolean minValue) {
        Value[] values = new Value[size];
        Value restOfValues = minValue ? Values.MIN_GLOBAL : Values.MAX_GLOBAL;
        System.arraycopy(equalityValues, 0, values, 0, equalityValues.length);
        values[equalityValues.length] = nextValue == null ? restOfValues : nextValue;
        for (int i = equalityValues.length + 1; i < size; ++i) {
            values[i] = restOfValues;
        }
        return ValueTuple.of((Value[])values);
    }

    private static class RangeFilterValues {
        ValueTuple lower;
        ValueTuple upper;
        boolean includeLower;
        boolean includeUpper;

        private RangeFilterValues(ValueTuple lower, boolean includeLower, ValueTuple upper, boolean includeUpper) {
            this.lower = lower;
            this.upper = upper;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
        }

        private static RangeFilterValues fromRange(int size, Value[] equalityValues, IndexQuery.RangePredicate<?> predicate) {
            boolean selectedIncludeUpper;
            ValueTuple selectedUpper;
            boolean selectedIncludeLower;
            ValueTuple selectedLower;
            Value lower = predicate.fromValue();
            Value upper = predicate.toValue();
            if (lower == null || upper == null) {
                throw new IllegalStateException("Use Values.NO_VALUE to encode the lack of a bound");
            }
            if (lower == Values.NO_VALUE) {
                Value min = Values.minValue((ValueGroup)predicate.valueGroup(), (Value)upper);
                selectedLower = TxStateIndexChanges.getCompositeValueTuple(size, equalityValues, min, true);
                selectedIncludeLower = true;
            } else {
                selectedLower = TxStateIndexChanges.getCompositeValueTuple(size, equalityValues, lower, true);
                selectedIncludeLower = predicate.fromInclusive();
            }
            if (upper == Values.NO_VALUE) {
                Value max = Values.maxValue((ValueGroup)predicate.valueGroup(), (Value)lower);
                selectedUpper = TxStateIndexChanges.getCompositeValueTuple(size, equalityValues, max, false);
                selectedIncludeUpper = false;
            } else {
                selectedUpper = TxStateIndexChanges.getCompositeValueTuple(size, equalityValues, upper, false);
                selectedIncludeUpper = predicate.toInclusive();
            }
            return new RangeFilterValues(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
        }

        private static RangeFilterValues fromExists(int size, Value[] equalityValues) {
            ValueTuple min = TxStateIndexChanges.getCompositeValueTuple(size, equalityValues, null, true);
            ValueTuple max = TxStateIndexChanges.getCompositeValueTuple(size, equalityValues, null, false);
            return new RangeFilterValues(min, true, max, true);
        }

        private boolean allowedEntry(Value entry, int length) {
            int compareUpper;
            if (this.includeLower && this.includeUpper) {
                return true;
            }
            int compareLower = Values.COMPARATOR.compare(this.lower.valueAt(length), entry);
            if (compareLower == (compareUpper = Values.COMPARATOR.compare(this.upper.valueAt(length), entry))) {
                return false;
            }
            return compareLower != 0 && compareUpper != 0 || compareLower == 0 && this.includeLower || compareUpper == 0 && this.includeUpper;
        }
    }

    public static class AddedWithValuesAndRemoved {
        private final Iterable<NodeWithPropertyValues> added;
        private final LongSet removed;

        AddedWithValuesAndRemoved(Iterable<NodeWithPropertyValues> added, LongSet removed) {
            this.added = added;
            this.removed = removed;
        }

        public boolean isEmpty() {
            return !this.added.iterator().hasNext() && this.removed.isEmpty();
        }

        public Iterable<NodeWithPropertyValues> getAdded() {
            return this.added;
        }

        public LongSet getRemoved() {
            return this.removed;
        }
    }

    public static class AddedAndRemoved {
        private final LongIterable added;
        private final LongSet removed;

        AddedAndRemoved(LongIterable added, LongSet removed) {
            this.added = added;
            this.removed = removed;
        }

        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty();
        }

        public LongIterable getAdded() {
            return this.added;
        }

        public LongSet getRemoved() {
            return this.removed;
        }
    }
}

