/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.annotations.service.Service;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;

@Service
public abstract class DiagnosticsOfflineReportProvider {
    private final Set<String> filterClassifiers;

    protected DiagnosticsOfflineReportProvider(String classifier, String ... classifiers) {
        this.filterClassifiers = new HashSet<String>(Arrays.asList(classifiers));
        this.filterClassifiers.add(classifier);
    }

    public abstract void init(FileSystemAbstraction var1, String var2, Config var3, File var4);

    protected abstract List<DiagnosticsReportSource> provideSources(Set<String> var1);

    final Set<String> getFilterClassifiers() {
        return this.filterClassifiers;
    }

    final List<DiagnosticsReportSource> getDiagnosticsSources(Set<String> classifiers) {
        if (classifiers.contains("all")) {
            return this.provideSources(this.filterClassifiers);
        }
        return this.provideSources(classifiers);
    }
}

