/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.watcher;

import java.nio.file.WatchKey;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.resource.WatchedResource;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class DefaultFileDeletionEventListener
implements FileWatchEventListener {
    private final NormalizedDatabaseName databaseName;
    private final Set<WatchedResource> watchedResources;
    private final Log internalLog;
    private final Predicate<String> fileNameFilter;

    DefaultFileDeletionEventListener(NormalizedDatabaseName databaseName, Set<WatchedResource> watchedResources, LogService logService, Predicate<String> fileNameFilter) {
        this.databaseName = databaseName;
        this.watchedResources = watchedResources;
        this.internalLog = logService.getInternalLog(this.getClass());
        this.fileNameFilter = fileNameFilter;
    }

    public void fileDeleted(WatchKey key, String fileName) {
        if (this.isListenedResource(key) && !this.fileNameFilter.test(fileName)) {
            this.internalLog.error("'%s' which belongs to the '%s' database was deleted while it was running.", new Object[]{fileName, this.databaseName.name()});
        }
    }

    private boolean isListenedResource(WatchKey watchKey) {
        return this.watchedResources.stream().map(WatchedResource::getWatchKey).anyMatch(watchKey::equals);
    }
}

