/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.storageengine.api.StorageEntityScanCursor;

class TokenScanViewIdIterator<CURSOR extends StorageEntityScanCursor>
implements EntityIdIterator {
    private final int[] tokenIds;
    private final TokenScanReader tokenScanReader;
    private final CURSOR entityCursor;
    private final PageCursorTracer cursorTracer;
    private PrimitiveLongResourceIterator idIterator;
    private long lastReturnedId = -1L;

    TokenScanViewIdIterator(TokenScanReader tokenScanReader, int[] tokenIds, CURSOR entityCursor, PageCursorTracer cursorTracer) {
        this.tokenScanReader = tokenScanReader;
        this.entityCursor = entityCursor;
        this.cursorTracer = cursorTracer;
        this.idIterator = tokenScanReader.entitiesWithAnyOfTokens(tokenIds, cursorTracer);
        this.tokenIds = tokenIds;
    }

    public void close() {
        this.idIterator.close();
    }

    public boolean hasNext() {
        return this.idIterator.hasNext();
    }

    public long next() {
        long next = this.idIterator.next();
        this.entityCursor.single(next);
        this.entityCursor.next();
        this.lastReturnedId = next;
        return next;
    }

    @Override
    public void invalidateCache() {
        this.idIterator.close();
        this.idIterator = this.tokenScanReader.entitiesWithAnyOfTokens(this.lastReturnedId, this.tokenIds, this.cursorTracer);
    }
}

