/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;

public class ReaderLogVersionBridge
implements LogVersionBridge {
    private final LogFiles logFiles;

    public ReaderLogVersionBridge(LogFiles logFiles) {
        this.logFiles = logFiles;
    }

    @Override
    public LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
        PhysicalLogVersionedStoreChannel nextChannel;
        try {
            nextChannel = this.logFiles.openForVersion(channel.getVersion() + 1L);
        }
        catch (FileNotFoundException | IncompleteLogHeaderException e) {
            return channel;
        }
        channel.close();
        return nextChannel;
    }
}

