/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.neo4j.scheduler.DeferredExecutor;

public class BufferingExecutor
implements DeferredExecutor {
    private final Queue<Runnable> buffer = new LinkedList<Runnable>();
    private volatile Executor realExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void satisfyWith(Executor executor) {
        BufferingExecutor bufferingExecutor = this;
        synchronized (bufferingExecutor) {
            if (this.realExecutor != null) {
                throw new RuntimeException("real executor is already set. Cannot override");
            }
            this.realExecutor = executor;
            this.replayBuffer();
        }
    }

    private void replayBuffer() {
        Runnable command = this.pollRunnable();
        while (command != null) {
            this.realExecutor.execute(command);
            command = this.pollRunnable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable pollRunnable() {
        Queue<Runnable> queue = this.buffer;
        synchronized (queue) {
            return this.buffer.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRunnable(Runnable command) {
        Queue<Runnable> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Nonnull Runnable command) {
        if (this.realExecutor != null) {
            this.realExecutor.execute(command);
            return;
        }
        BufferingExecutor bufferingExecutor = this;
        synchronized (bufferingExecutor) {
            if (this.realExecutor != null) {
                this.realExecutor.execute(command);
            } else {
                this.queueRunnable(command);
            }
        }
    }
}

