/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.OutputStream;
import java.time.ZoneId;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.memory.MemoryPools;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;

public final class ConfigurableStandalonePageCacheFactory {
    private ConfigurableStandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler, PageCacheTracer pageCacheTracer) {
        Config config = Config.defaults();
        return ConfigurableStandalonePageCacheFactory.createPageCache(fileSystem, pageCacheTracer, config, EmptyVersionContextSupplier.EMPTY, jobScheduler, new MemoryPools(((Boolean)config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()));
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, JobScheduler jobScheduler, PageCacheTracer pageCacheTracer) {
        return ConfigurableStandalonePageCacheFactory.createPageCache(fileSystem, pageCacheTracer, config, EmptyVersionContextSupplier.EMPTY, jobScheduler, new MemoryPools(((Boolean)config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()));
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, Config config, VersionContextSupplier versionContextSupplier, JobScheduler jobScheduler, MemoryPools memoryPools) {
        config.setIfNotSet(GraphDatabaseSettings.pagecache_memory, (Object)"8M");
        ZoneId logTimeZone = ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
        FormattedLogProvider logProvider = FormattedLogProvider.withZoneId((ZoneId)logTimeZone).toOutputStream((OutputStream)System.err);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, pageCacheTracer, logProvider.getLog(PageCache.class), versionContextSupplier, jobScheduler, Clocks.nanoClock(), memoryPools);
        return pageCacheFactory.getOrCreatePageCache();
    }
}

