/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.function.Function;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.values.storable.ValueCategory;

public class FusionSlotSelector30
implements SlotSelector {
    @Override
    public void validateSatisfied(InstanceSelector<IndexProvider> instances) {
        SlotSelector.validateSelectorInstances(instances, IndexSlot.GENERIC, IndexSlot.LUCENE);
    }

    @Override
    public <V> IndexSlot selectSlot(V[] values, Function<V, ValueCategory> categoryOf) {
        if (values.length == 1) {
            switch (categoryOf.apply(values[0])) {
                case TEXT: {
                    return IndexSlot.LUCENE;
                }
                case UNKNOWN: {
                    return null;
                }
            }
            return IndexSlot.GENERIC;
        }
        return IndexSlot.GENERIC;
    }
}

