/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.internal;

import java.util.NoSuchElementException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.coreapi.internal.NodeFactory;

abstract class PrefetchingNodeResourceIterator
implements ResourceIterator<Node> {
    private final NodeFactory nodeFactory;
    private long next;
    private boolean closed;
    private static final long NOT_INITIALIZED = -2L;
    protected static final long NO_ID = -1L;

    PrefetchingNodeResourceIterator(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
        this.next = -2L;
    }

    public boolean hasNext() {
        if (this.next == -2L) {
            this.next = this.fetchNext();
        }
        return this.next != -1L;
    }

    public Node next() {
        if (!this.hasNext()) {
            this.close();
            throw new NoSuchElementException();
        }
        NodeEntity node = this.nodeFactory.make(this.next);
        this.next = this.fetchNext();
        return node;
    }

    public void close() {
        if (!this.closed) {
            this.next = -1L;
            this.closeResources();
            this.closed = true;
        }
    }

    abstract long fetchNext();

    abstract void closeResources();
}

