/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.state.EntityStateImpl;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.TrackableDiffSets;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.values.storable.Value;

class NodeStateImpl
extends EntityStateImpl
implements NodeState {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeStateImpl.class);
    static final NodeState EMPTY = new NodeState(){

        public Iterator<StorageProperty> addedProperties() {
            return Collections.emptyIterator();
        }

        public Iterator<StorageProperty> changedProperties() {
            return Collections.emptyIterator();
        }

        public IntIterable removedProperties() {
            return IntSets.immutable.empty();
        }

        public Iterator<StorageProperty> addedAndChangedProperties() {
            return Collections.emptyIterator();
        }

        public boolean hasPropertyChanges() {
            return false;
        }

        public LongDiffSets labelDiffSets() {
            return LongDiffSets.EMPTY;
        }

        public int augmentDegree(RelationshipDirection direction, int degree, int typeId) {
            return degree;
        }

        public long getId() {
            throw new UnsupportedOperationException("id not defined");
        }

        public boolean isPropertyChangedOrRemoved(int propertyKey) {
            return false;
        }

        public Value propertyValue(int propertyKey) {
            return null;
        }

        public LongIterator getAddedRelationships() {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public LongIterator getAddedRelationships(Direction direction) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public LongIterator getAddedRelationships(Direction direction, int relType) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public IntIterable getAddedRelationshipTypes() {
            return IntSets.immutable.empty();
        }

        public IntIterable getAddedAndRemovedRelationshipTypes() {
            return IntSets.immutable.empty();
        }
    };
    private MutableLongDiffSets labelDiffSets;
    private RelationshipChangesForNode relationshipsAdded;
    private RelationshipChangesForNode relationshipsRemoved;
    private Set<MutableLongDiffSets> indexDiffs;

    static NodeStateImpl createNodeState(long id, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new NodeStateImpl(id, collectionsFactory, memoryTracker);
    }

    private NodeStateImpl(long id, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        super(id, collectionsFactory, memoryTracker);
    }

    public LongDiffSets labelDiffSets() {
        return this.labelDiffSets == null ? LongDiffSets.EMPTY : this.labelDiffSets;
    }

    MutableLongDiffSets getOrCreateLabelDiffSets() {
        if (this.labelDiffSets == null) {
            this.labelDiffSets = TrackableDiffSets.newMutableLongDiffSets(this.collectionsFactory, this.memoryTracker);
        }
        return this.labelDiffSets;
    }

    public void addRelationship(long relId, int typeId, RelationshipDirection direction) {
        if (!this.hasAddedRelationships()) {
            this.relationshipsAdded = RelationshipChangesForNode.createRelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, this.memoryTracker);
        }
        this.relationshipsAdded.addRelationship(relId, typeId, direction);
    }

    public void removeRelationship(long relId, int typeId, RelationshipDirection direction) {
        if (this.hasAddedRelationships() && this.relationshipsAdded.removeRelationship(relId, typeId, direction)) {
            return;
        }
        if (!this.hasRemovedRelationships()) {
            this.relationshipsRemoved = RelationshipChangesForNode.createRelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.REMOVE, this.memoryTracker);
        }
        this.relationshipsRemoved.addRelationship(relId, typeId, direction);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.relationshipsAdded != null) {
            this.relationshipsAdded.clear();
        }
        if (this.relationshipsRemoved != null) {
            this.relationshipsRemoved.clear();
        }
        if (this.labelDiffSets != null) {
            this.labelDiffSets = null;
        }
        if (this.indexDiffs != null) {
            this.indexDiffs.clear();
        }
    }

    public int augmentDegree(RelationshipDirection direction, int degree, int typeId) {
        if (this.hasAddedRelationships()) {
            degree = this.relationshipsAdded.augmentDegree(direction, degree, typeId);
        }
        if (this.hasRemovedRelationships()) {
            degree = this.relationshipsRemoved.augmentDegree(direction, degree, typeId);
        }
        return degree;
    }

    private boolean hasAddedRelationships() {
        return this.relationshipsAdded != null;
    }

    private boolean hasRemovedRelationships() {
        return this.relationshipsRemoved != null;
    }

    void addIndexDiff(MutableLongDiffSets diff) {
        if (this.indexDiffs == null) {
            this.indexDiffs = HeapTrackingCollections.newIdentityHashingSet((MemoryTracker)this.memoryTracker);
        }
        this.indexDiffs.add(diff);
    }

    void removeIndexDiff(MutableLongDiffSets diff) {
        if (this.indexDiffs != null) {
            this.indexDiffs.remove(diff);
        }
    }

    void clearIndexDiffs(long nodeId) {
        if (this.indexDiffs != null) {
            for (MutableLongDiffSets diff : this.indexDiffs) {
                if (diff.getAdded().contains(nodeId)) {
                    diff.remove(nodeId);
                    continue;
                }
                if (!diff.getRemoved().contains(nodeId)) continue;
                diff.add(nodeId);
            }
        }
    }

    public LongIterator getAddedRelationships() {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships() : ImmutableEmptyLongIterator.INSTANCE;
    }

    public LongIterator getAddedRelationships(Direction direction) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction) : ImmutableEmptyLongIterator.INSTANCE;
    }

    public LongIterator getAddedRelationships(Direction direction, int relType) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction, relType) : ImmutableEmptyLongIterator.INSTANCE;
    }

    public IntIterable getAddedRelationshipTypes() {
        return this.relationshipsAdded != null ? this.relationshipsAdded.relationshipTypes() : IntSets.immutable.empty();
    }

    public IntIterable getAddedAndRemovedRelationshipTypes() {
        if (this.relationshipsAdded == null && this.relationshipsRemoved == null) {
            return IntSets.immutable.empty();
        }
        if (this.relationshipsAdded != null && this.relationshipsRemoved != null) {
            MutableIntSet types = IntSets.mutable.withAll((IntIterable)this.relationshipsAdded.relationshipTypes());
            types.addAll((IntIterable)this.relationshipsRemoved.relationshipTypes());
            return types;
        }
        return this.relationshipsAdded != null ? this.relationshipsAdded.relationshipTypes() : this.relationshipsRemoved.relationshipTypes();
    }
}

