/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.RecoveryState;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageFilesState;

class RecoveryRequiredChecker {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final Config config;
    private final StorageEngineFactory storageEngineFactory;

    RecoveryRequiredChecker(FileSystemAbstraction fs, PageCache pageCache, Config config, StorageEngineFactory storageEngineFactory) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.config = config;
        this.storageEngineFactory = storageEngineFactory;
    }

    public boolean isRecoveryRequiredAt(DatabaseLayout databaseLayout, MemoryTracker memoryTracker) throws IOException {
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        LogFiles logFiles = this.buildLogFiles(databaseLayout, (LogEntryReader)reader);
        LogTailScanner tailScanner = new LogTailScanner(logFiles, (LogEntryReader)reader, new Monitors(), true, memoryTracker);
        return this.isRecoveryRequiredAt(databaseLayout, tailScanner, logFiles);
    }

    private LogFiles buildLogFiles(DatabaseLayout databaseLayout, LogEntryReader reader) throws IOException {
        return LogFilesBuilder.activeFilesBuilder(databaseLayout, this.fs, this.pageCache).withConfig(this.config).withLogEntryReader(reader).build();
    }

    boolean isRecoveryRequiredAt(DatabaseLayout databaseLayout, LogTailScanner tailScanner) throws IOException {
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        LogFiles logFiles = this.buildLogFiles(databaseLayout, (LogEntryReader)reader);
        return this.isRecoveryRequiredAt(databaseLayout, tailScanner, logFiles);
    }

    boolean isRecoveryRequiredAt(DatabaseLayout databaseLayout, LogTailScanner tailScanner, LogFiles logFiles) {
        if (!this.storageEngineFactory.storageExists(this.fs, databaseLayout, this.pageCache)) {
            return false;
        }
        StorageFilesState filesRecoveryState = this.storageEngineFactory.checkRecoveryRequired(this.fs, databaseLayout, this.pageCache);
        if (filesRecoveryState.getRecoveryState() != RecoveryState.RECOVERED) {
            return true;
        }
        return new RecoveryStartInformationProvider(tailScanner, logFiles, RecoveryStartInformationProvider.NO_MONITOR).get().isRecoveryRequired();
    }
}

