/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.index.schema.SpatialIndexConfig;
import org.neo4j.kernel.impl.storemigration.IndexConfigExtractorUtil;
import org.neo4j.kernel.impl.storemigration.SpatialFile;
import org.neo4j.logging.Log;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;

final class SpatialConfigExtractor {
    private static final byte BYTE_FAILED = 0;
    private static final int SPATIAL_INDEX_TYPE_SPACE_FILLING_CURVE = 1;

    private SpatialConfigExtractor() {
    }

    static IndexConfig indexConfigFromSpatialFile(PageCache pageCache, List<SpatialFile> spatialFiles, PageCursorTracer cursorTracer, Log log) throws IOException {
        Map<String, Object> map = new HashMap<String, Value>();
        for (SpatialFile spatialFile : spatialFiles) {
            try {
                GBPTree.readHeader((PageCache)pageCache, (File)spatialFile.getIndexFile(), (Header.Reader)SpatialConfigExtractor.headerReader(map, spatialFile, log), (PageCursorTracer)cursorTracer);
            }
            catch (MetadataMismatchException e) {
                IndexConfigExtractorUtil.logExtractionFailure("Index meta data is corrupt and can not be parsed.", log, spatialFile.getIndexFile());
                map = Collections.emptyMap();
                break;
            }
        }
        return IndexConfig.with(map);
    }

    private static Header.Reader headerReader(Map<String, Value> map, SpatialFile spatialFile, Log log) {
        return headerBytes -> {
            byte state = headerBytes.get();
            if (state != 0) {
                int typeId = headerBytes.getInt();
                if (typeId == 1) {
                    try {
                        int maxLevels = headerBytes.getInt();
                        int dimensions = headerBytes.getInt();
                        double[] min = new double[dimensions];
                        double[] max = new double[dimensions];
                        for (int i = 0; i < dimensions; ++i) {
                            min[i] = headerBytes.getDouble();
                            max[i] = headerBytes.getDouble();
                        }
                        CoordinateReferenceSystem crs = spatialFile.getCrs();
                        SpatialIndexConfig.addSpatialConfig(map, crs, min, max);
                    }
                    catch (BufferUnderflowException e) {
                        IndexConfigExtractorUtil.logExtractionFailure("Got an exception, " + e + ".", log, spatialFile.getIndexFile());
                    }
                } else {
                    IndexConfigExtractorUtil.logExtractionFailure("Spatial index file is of an unknown type, typeId=" + state + ".", log, spatialFile.getIndexFile());
                }
            } else {
                IndexConfigExtractorUtil.logExtractionFailure("Index is in FAILED state.", log, spatialFile.getIndexFile());
            }
        };
    }
}

