/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.storemigration.IndexMigration;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;

public class IndexProviderMigrator
extends AbstractStoreMigrationParticipant {
    private static final String INDEX_PROVIDER_MIGRATION_TAG = "indexProviderMigration";
    private final FileSystemAbstraction fs;
    private final Config config;
    private final PageCache pageCache;
    private final LogService logService;
    private final StorageEngineFactory storageEngineFactory;
    private final PageCacheTracer cacheTracer;
    private final MemoryTracker memoryTracker;

    IndexProviderMigrator(FileSystemAbstraction fs, Config config, PageCache pageCache, LogService logService, StorageEngineFactory storageEngineFactory, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        super("Index providers");
        this.fs = fs;
        this.config = config;
        this.pageCache = pageCache;
        this.logService = logService;
        this.storageEngineFactory = storageEngineFactory;
        this.cacheTracer = cacheTracer;
        this.memoryTracker = memoryTracker;
    }

    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progress, String versionToMigrateFrom, String versionToMigrateTo) throws KernelException, IOException {
        if (this.needProviderMigration(versionToMigrateFrom, versionToMigrateTo)) {
            this.migrateIndexProviders(migrationLayout, versionToMigrateTo);
        }
    }

    private void migrateIndexProviders(DatabaseLayout migrationLayout, String versionToMigrateTo) throws IOException, KernelException {
        try (PageCursorTracer cursorTracer = this.cacheTracer.createPageCursorTracer(INDEX_PROVIDER_MIGRATION_TAG);
             SchemaRuleMigrationAccess ruleAccess = this.storageEngineFactory.schemaRuleMigrationAccess(this.fs, this.pageCache, this.config, migrationLayout, this.logService, versionToMigrateTo, this.cacheTracer, cursorTracer, this.memoryTracker);){
            for (SchemaRule rule : ruleAccess.getAll()) {
                SchemaRule upgraded = this.upgradeIndexProvider(rule);
                if (upgraded == rule) continue;
                ruleAccess.writeSchemaRule(upgraded);
            }
        }
    }

    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (this.needProviderMigration(versionToMigrateFrom, versionToMigrateTo)) {
            for (IndexMigration indexMigration : IndexMigration.retired()) {
                for (File retiredRootDirectory : indexMigration.providerRootDirectories(directoryLayout)) {
                    this.fs.deleteRecursively(retiredRootDirectory);
                }
            }
        }
    }

    public void cleanup(DatabaseLayout migrationLayout) {
    }

    private SchemaRule upgradeIndexProvider(SchemaRule rule) {
        if (rule instanceof IndexDescriptor) {
            IndexDescriptor old = (IndexDescriptor)rule;
            IndexProviderDescriptor provider = old.getIndexProvider();
            String currentKey = provider.getKey();
            String currentVersion = provider.getVersion();
            for (IndexMigration retired : IndexMigration.retired()) {
                if (!currentKey.equals(retired.providerKey) || !currentVersion.equals(retired.providerVersion)) continue;
                IndexProviderDescriptor replacement = retired.desiredAlternativeProvider;
                return old.withIndexProvider(replacement);
            }
        }
        return rule;
    }

    private boolean needProviderMigration(String versionToMigrateFrom, String versionToMigrateTo) {
        StoreVersion toVersionInformation;
        StoreVersion fromVersionInformation = this.storageEngineFactory.versionInformation(versionToMigrateFrom);
        return !fromVersionInformation.hasCompatibleCapabilities(toVersionInformation = this.storageEngineFactory.versionInformation(versionToMigrateTo), CapabilityType.INDEX_PROVIDER);
    }
}

