/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.LongPredicate;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

class DetachingRelationshipDeleter {
    private final LongPredicate relationshipDeleter;

    DetachingRelationshipDeleter(LongPredicate relationshipDeleter) {
        this.relationshipDeleter = relationshipDeleter;
    }

    int lockNodesAndDeleteRelationships(long nodeId, KernelTransactionImplementation ktx) {
        LongHashSet relIds;
        boolean retry;
        Locks.Client locks = ktx.statementLocks().optimistic();
        LockTracer lockTracer = ktx.lockTracer();
        PageCursorTracer cursorTracer = ktx.pageCursorTracer();
        NodeCursor nodes = ktx.ambientNodeCursor();
        CursorFactory cursors = ktx.cursors();
        do {
            retry = false;
            LongHashSet nodeIds = new LongHashSet();
            relIds = new LongHashSet();
            ktx.dataRead().singleNode(nodeId, nodes);
            if (nodes.next()) {
                nodeIds.add(nodes.nodeReference());
                try (RelationshipTraversalCursor rels = RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)nodes, null, (PageCursorTracer)cursorTracer);){
                    while (rels.next()) {
                        relIds.add(rels.relationshipReference());
                        nodeIds.add(rels.sourceNodeReference());
                        nodeIds.add(rels.targetNodeReference());
                    }
                }
            }
            locks.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.NODE, nodeIds.toSortedArray());
            ktx.dataRead().singleNode(nodeId, nodes);
            if (nodes.next()) {
                int verifiedRels = 0;
                try (RelationshipTraversalCursor rels = RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)nodes, null, (PageCursorTracer)cursorTracer);){
                    while (rels.next() && !retry) {
                        retry = !relIds.contains(rels.relationshipReference());
                        retry |= !nodeIds.contains(rels.sourceNodeReference());
                        retry |= !nodeIds.contains(rels.targetNodeReference());
                        ++verifiedRels;
                    }
                }
                if (!(retry |= verifiedRels != relIds.size())) continue;
                locks.releaseExclusive((ResourceType)ResourceTypes.NODE, nodeIds.toSortedArray());
                continue;
            }
            locks.releaseExclusive((ResourceType)ResourceTypes.NODE, nodeIds.toSortedArray());
            return 0;
        } while (retry);
        int relationshipsDeleted = 0;
        for (long relId : relIds.toSortedArray()) {
            locks.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.RELATIONSHIP, relId);
            if (this.relationshipDeleter.test(relId)) {
                ++relationshipsDeleted;
                continue;
            }
            locks.releaseExclusive((ResourceType)ResourceTypes.RELATIONSHIP, relId);
        }
        return relationshipsDeleted;
    }
}

