/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public class IndexFiles {
    private final FileSystemAbstraction fs;
    private final File directory;
    private final File storeFile;

    public IndexFiles(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure, long indexId) {
        this.fs = fs;
        this.directory = directoryStructure.directoryForIndex(indexId);
        this.storeFile = new File(this.directory, IndexFiles.indexFileName(indexId));
    }

    private static String indexFileName(long indexId) {
        return "index-" + indexId;
    }

    public File getStoreFile() {
        return this.storeFile;
    }

    public File getBase() {
        return this.directory;
    }

    public void clear() {
        try {
            this.fs.deleteRecursively(this.directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void archiveIndex() {
        if (this.fs.isDirectory(this.directory) && this.fs.fileExists(this.directory) && this.fs.listFiles(this.directory).length > 0) {
            try {
                ZipUtils.zip((FileSystemAbstraction)this.fs, (File)this.directory, (File)new File(this.directory.getParent(), "archive-" + this.directory.getName() + "-" + System.currentTimeMillis() + ".zip"));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void ensureDirectoryExist() {
        try {
            this.fs.mkdirs(this.directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return String.format("%s[base=%s,storeFile=%s]", this.getClass().getSimpleName(), this.getBase(), this.getStoreFile());
    }
}

