/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.BlockEntryReader;
import org.neo4j.kernel.impl.index.schema.BlockReader;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexKeyStorage;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateCursor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateStorage;
import org.neo4j.kernel.impl.index.schema.MergingBlockEntryReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.Runnables;
import org.neo4j.values.storable.Value;

public abstract class BlockBasedIndexPopulator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexPopulator<KEY, VALUE> {
    public static final String BLOCK_SIZE_NAME = "blockSize";
    private final boolean archiveFailedIndex;
    private final MemoryTracker memoryTracker;
    private final int mergeFactor;
    private final BlockStorage.Monitor blockStorageMonitor;
    private final List<ThreadLocalBlockStorage> allScanUpdates = new CopyOnWriteArrayList<ThreadLocalBlockStorage>();
    private final ThreadLocal<ThreadLocalBlockStorage> scanUpdates;
    private final ByteBufferFactory bufferFactory;
    private IndexUpdateStorage<KEY, VALUE> externalUpdates;
    private volatile boolean scanCompleted;
    private final CloseCancellation cancellation = new CloseCancellation();
    private volatile CountDownLatch mergeOngoingLatch;
    private IndexSample nonUniqueIndexSample;
    private final AtomicLong numberOfIndexUpdatesSinceSample = new AtomicLong();
    private IndexValueValidator validator;
    private final AtomicLong numberOfAppliedScanUpdates = new AtomicLong();
    private final AtomicLong numberOfAppliedExternalUpdates = new AtomicLong();

    BlockBasedIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY, VALUE> layout, IndexDescriptor descriptor, boolean archiveFailedIndex, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker) {
        this(databaseIndexContext, indexFiles, layout, descriptor, archiveFailedIndex, bufferFactory, memoryTracker, FeatureToggles.getInteger(BlockBasedIndexPopulator.class, (String)"mergeFactor", (int)8), BlockStorage.Monitor.NO_MONITOR, GBPTree.NO_MONITOR);
    }

    BlockBasedIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY, VALUE> layout, IndexDescriptor descriptor, boolean archiveFailedIndex, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, int mergeFactor, BlockStorage.Monitor blockStorageMonitor, GBPTree.Monitor treeMonitor) {
        super(databaseIndexContext, indexFiles, layout, descriptor, GBPTree.NO_HEADER_WRITER, treeMonitor);
        this.archiveFailedIndex = archiveFailedIndex;
        this.memoryTracker = memoryTracker;
        this.mergeFactor = mergeFactor;
        this.blockStorageMonitor = blockStorageMonitor;
        this.scanUpdates = ThreadLocal.withInitial(this::newThreadLocalBlockStorage);
        this.bufferFactory = bufferFactory;
    }

    private synchronized ThreadLocalBlockStorage newThreadLocalBlockStorage() {
        Preconditions.checkState((!this.cancellation.cancelled() ? 1 : 0) != 0, (String)"Already closed");
        Preconditions.checkState((!this.scanCompleted ? 1 : 0) != 0, (String)"Scan has already been completed");
        try {
            int id = this.allScanUpdates.size();
            ThreadLocalBlockStorage blockStorage = new ThreadLocalBlockStorage(id);
            this.allScanUpdates.add(blockStorage);
            return blockStorage;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static int parseBlockSize() {
        long blockSize = ByteUnit.parse((String)FeatureToggles.getString(BlockBasedIndexPopulator.class, (String)BLOCK_SIZE_NAME, (String)"1M"));
        Preconditions.checkArgument((blockSize >= 20L && blockSize < Integer.MAX_VALUE ? 1 : 0) != 0, (String)("Block size need to fit in int. Was " + blockSize));
        return (int)blockSize;
    }

    @Override
    public void create() {
        if (this.archiveFailedIndex) {
            this.indexFiles.archiveIndex();
        }
        super.create();
        File storeFile = this.indexFiles.getStoreFile();
        File externalUpdatesFile = new File(storeFile.getParent(), storeFile.getName() + ".ext");
        this.validator = this.instantiateValueValidator();
        this.externalUpdates = new IndexUpdateStorage(this.fileSystem, externalUpdatesFile, this.bufferFactory.globalAllocator(), this.smallerBufferSize(), this.layout, this.memoryTracker);
    }

    protected abstract IndexValueValidator instantiateValueValidator();

    private int smallerBufferSize() {
        return this.bufferFactory.bufferSize() / 2;
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates, PageCursorTracer cursorTracer) {
        if (!updates.isEmpty()) {
            BlockStorage blockStorage = this.scanUpdates.get().blockStorage;
            for (IndexEntryUpdate<?> update : updates) {
                this.storeUpdate(update, blockStorage);
            }
        }
    }

    private void storeUpdate(long entityId, Value[] values, BlockStorage<KEY, VALUE> blockStorage) {
        try {
            this.validator.validate(entityId, values);
            NativeIndexKey key = (NativeIndexKey)((Object)this.layout.newKey());
            Object value = this.layout.newValue();
            NativeIndexUpdater.initializeKeyFromUpdate(key, entityId, values);
            ((NativeIndexValue)value).from(values);
            blockStorage.add(key, value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void storeUpdate(IndexEntryUpdate<?> update, BlockStorage<KEY, VALUE> blockStorage) {
        this.storeUpdate(update.getEntityId(), update.values(), blockStorage);
    }

    private synchronized boolean markMergeStarted() {
        this.scanCompleted = true;
        if (this.cancellation.cancelled()) {
            return false;
        }
        this.mergeOngoingLatch = new CountDownLatch(1);
        return true;
    }

    public void scanCompleted(PhaseTracker phaseTracker, JobScheduler jobScheduler, PageCursorTracer cursorTracer) throws IndexEntryConflictException {
        if (!this.markMergeStarted()) {
            return;
        }
        try {
            block29: {
                phaseTracker.enterPhase(PhaseTracker.Phase.MERGE);
                if (!this.allScanUpdates.isEmpty()) {
                    this.mergeScanUpdates(jobScheduler);
                }
                this.externalUpdates.doneAdding();
                if (this.cancellation.cancelled()) {
                    return;
                }
                phaseTracker.enterPhase(PhaseTracker.Phase.BUILD);
                File storeFile = this.indexFiles.getStoreFile();
                File duplicatesFile = new File(storeFile.getParentFile(), storeFile.getName() + ".dup");
                int readBufferSize = this.smallerBufferSize();
                try (ByteBufferFactory.Allocator allocator = this.bufferFactory.newLocalAllocator();
                     IndexKeyStorage indexKeyStorage = new IndexKeyStorage(this.fileSystem, duplicatesFile, allocator, readBufferSize, this.layout, this.memoryTracker);){
                    RecordingConflictDetector recordingConflictDetector = new RecordingConflictDetector(!this.descriptor.isUnique(), indexKeyStorage);
                    this.writeScanUpdatesToTree(recordingConflictDetector, allocator, readBufferSize, cursorTracer);
                    phaseTracker.enterPhase(PhaseTracker.Phase.APPLY_EXTERNAL);
                    this.writeExternalUpdatesToTree(recordingConflictDetector, cursorTracer);
                    if (this.descriptor.isUnique()) {
                        try (IndexKeyStorage.KeyEntryCursor allConflictingKeys = recordingConflictDetector.allConflicts();){
                            this.verifyUniqueKeys(allConflictingKeys, cursorTracer);
                            break block29;
                        }
                    }
                    this.nonUniqueIndexSample = this.buildNonUniqueIndexSample(cursorTracer);
                }
            }
            this.flushTreeAndMarkAs((byte)2, cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Got interrupted, so merge not completed", e);
        }
        catch (ExecutionException e) {
            Throwable executionException = e.getCause();
            Exceptions.throwIfUnchecked((Throwable)executionException);
            throw new RuntimeException(executionException);
        }
        finally {
            this.mergeOngoingLatch.countDown();
        }
    }

    private void mergeScanUpdates(JobScheduler jobScheduler) throws InterruptedException, ExecutionException, IOException {
        ArrayList<JobHandle> mergeFutures = new ArrayList<JobHandle>();
        for (ThreadLocalBlockStorage part : this.allScanUpdates) {
            BlockStorage scanUpdates = part.blockStorage;
            scanUpdates.doneAdding();
            mergeFutures.add(jobScheduler.schedule(Group.INDEX_POPULATION_WORK, () -> {
                scanUpdates.merge(this.mergeFactor, this.cancellation);
                return null;
            }));
        }
        for (JobHandle mergeFuture : mergeFutures) {
            mergeFuture.get();
        }
    }

    private void writeExternalUpdatesToTree(RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, PageCursorTracer cursorTracer) throws IOException, IndexEntryConflictException {
        try (Writer writer = this.tree.writer(cursorTracer);
             IndexUpdateCursor updates = (IndexUpdateCursor)this.externalUpdates.reader();){
            while (updates.next() && !this.cancellation.cancelled()) {
                switch (updates.updateMode()) {
                    case ADDED: {
                        this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)((Object)updates.key()), (NativeIndexValue)updates.value());
                        break;
                    }
                    case REMOVED: {
                        writer.remove((Object)((NativeIndexKey)((Object)updates.key())));
                        break;
                    }
                    case CHANGED: {
                        writer.remove((Object)((NativeIndexKey)((Object)updates.key())));
                        this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)((Object)updates.key2()), (NativeIndexValue)updates.value());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown update mode " + updates.updateMode());
                    }
                }
                this.numberOfAppliedExternalUpdates.incrementAndGet();
            }
        }
    }

    private void verifyUniqueKeys(IndexKeyStorage.KeyEntryCursor<KEY> allConflictingKeys, PageCursorTracer cursorTracer) throws IOException, IndexEntryConflictException {
        while (allConflictingKeys.next() && !this.cancellation.cancelled()) {
            NativeIndexKey key = (NativeIndexKey)((Object)allConflictingKeys.key());
            key.setCompareId(false);
            Seeker seeker = this.tree.seek((Object)key, (Object)key, cursorTracer);
            try {
                this.verifyUniqueSeek(seeker);
            }
            finally {
                if (seeker == null) continue;
                seeker.close();
            }
        }
    }

    private void verifyUniqueSeek(Seeker<KEY, VALUE> seek) throws IOException, IndexEntryConflictException {
        if (seek != null && seek.next()) {
            NativeIndexKey key = (NativeIndexKey)((Object)seek.key());
            long firstEntityId = key.getEntityId();
            if (seek.next()) {
                long secondEntityId = key.getEntityId();
                throw new IndexEntryConflictException(firstEntityId, secondEntityId, key.asValues());
            }
        }
    }

    private void writeScanUpdatesToTree(RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, ByteBufferFactory.Allocator allocator, int bufferSize, PageCursorTracer cursorTracer) throws IOException, IndexEntryConflictException {
        try (MergingBlockEntryReader allEntries = new MergingBlockEntryReader(this.layout);
             ScopedBuffer singleBlockScopedBuffer = allocator.allocate((int)ByteUnit.kibiBytes((long)8L), this.memoryTracker);
             CompositeBuffer readBuffers = new CompositeBuffer();){
            for (ThreadLocalBlockStorage part : this.allScanUpdates) {
                ScopedBuffer readScopedBuffer = allocator.allocate(bufferSize, this.memoryTracker);
                readBuffers.addBuffer((AutoCloseable)readScopedBuffer);
                BlockReader reader = part.blockStorage.reader();
                try {
                    BlockEntryReader singleMergedBlock = reader.nextBlock(readScopedBuffer);
                    if (singleMergedBlock == null) continue;
                    allEntries.addSource(singleMergedBlock);
                    if (reader.nextBlock(singleBlockScopedBuffer) == null) continue;
                    throw new IllegalStateException("Final BlockStorage had multiple blocks");
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            boolean asMuchAsPossibleToTheLeft = true;
            try (Writer writer = this.tree.writer((double)asMuchAsPossibleToTheLeft, cursorTracer);){
                while (allEntries.next() && !this.cancellation.cancelled()) {
                    this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)((Object)allEntries.key()), (NativeIndexValue)allEntries.value());
                    this.numberOfAppliedScanUpdates.incrementAndGet();
                }
            }
        }
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PageCursorTracer cursorTracer) {
        if (this.scanCompleted) {
            return new DelegatingIndexUpdater(super.newPopulatingUpdater(cursorTracer)){

                @Override
                public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
                    BlockBasedIndexPopulator.this.validateUpdate(update);
                    BlockBasedIndexPopulator.this.numberOfIndexUpdatesSinceSample.incrementAndGet();
                    super.process(update);
                }
            };
        }
        return new IndexUpdater(){
            private volatile boolean closed;

            public void process(IndexEntryUpdate<?> update) {
                this.assertOpen();
                try {
                    BlockBasedIndexPopulator.this.validateUpdate(update);
                    BlockBasedIndexPopulator.this.externalUpdates.add(update);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public void close() {
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
    }

    private void validateUpdate(IndexEntryUpdate<?> update) {
        if (update.updateMode() != UpdateMode.REMOVED) {
            this.validator.validate(update.getEntityId(), update.values());
        }
    }

    @Override
    public synchronized void drop() {
        Runnables.runAll((String)"Failed while trying to drop index", (Runnable[])new Runnable[]{this::closeBlockStorage, () -> super.drop()});
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully, PageCursorTracer cursorTracer) {
        Runnables.runAll((String)"Failed while trying to close index", (Runnable[])new Runnable[]{this::closeBlockStorage, () -> super.close(populationCompletedSuccessfully, cursorTracer)});
    }

    private void closeBlockStorage() {
        this.cancellation.setCancel();
        if (this.mergeOngoingLatch != null) {
            try {
                this.mergeOngoingLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        List toClose = this.allScanUpdates.stream().map(local -> local.blockStorage).collect(Collectors.toCollection(ArrayList::new));
        toClose.add(this.externalUpdates);
        IOUtils.closeAllUnchecked((Collection)toClose);
    }

    public PopulationProgress progress(PopulationProgress scanProgress) {
        PopulationProgress treeBuildProgress;
        PopulationProgress.MultiBuilder builder = PopulationProgress.multiple();
        builder.add(scanProgress, 4.0f);
        if (!this.allScanUpdates.isEmpty()) {
            long completed = 0L;
            long total = 0L;
            if (this.scanCompleted) {
                ThreadLocalBlockStorage part2 = (ThreadLocalBlockStorage)Iterables.first(this.allScanUpdates);
                completed = part2.entriesMerged.get();
                total = part2.totalEntriesToMerge;
            }
            builder.add(PopulationProgress.single((long)completed, (long)total), 1.0f);
        }
        if (this.allScanUpdates.stream().allMatch(part -> part.mergeStarted)) {
            long entryCount = this.allScanUpdates.stream().mapToLong(part -> part.count).sum() + this.externalUpdates.count();
            treeBuildProgress = PopulationProgress.single((long)(this.numberOfAppliedScanUpdates.get() + this.numberOfAppliedExternalUpdates.get()), (long)entryCount);
        } else {
            treeBuildProgress = PopulationProgress.NONE;
        }
        builder.add(treeBuildProgress, 2.0f);
        return builder.build();
    }

    private void writeToTree(Writer<KEY, VALUE> writer, RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, KEY key, VALUE value) throws IndexEntryConflictException {
        recordingConflictDetector.controlConflictDetection(key);
        writer.merge(key, value, recordingConflictDetector);
        this.handleMergeConflict(writer, recordingConflictDetector, key, value);
    }

    private void handleMergeConflict(Writer<KEY, VALUE> writer, RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, KEY key, VALUE value) throws IndexEntryConflictException {
        if (recordingConflictDetector.wasConflicting()) {
            NativeIndexKey copy = (NativeIndexKey)((Object)this.layout.newKey());
            this.layout.copyKey(key, (Object)copy);
            recordingConflictDetector.reportConflict(copy);
            recordingConflictDetector.relaxUniqueness(key);
            writer.put(key, value);
        }
    }

    @Override
    public IndexSample sample(PageCursorTracer cursorTracer) {
        if (!this.descriptor.isUnique()) {
            return new IndexSample(this.nonUniqueIndexSample.indexSize(), this.nonUniqueIndexSample.uniqueValues(), this.nonUniqueIndexSample.sampleSize(), this.numberOfIndexUpdatesSinceSample.get());
        }
        return super.sample(cursorTracer);
    }

    private static class CompositeBuffer
    implements AutoCloseable {
        private final Collection<AutoCloseable> buffers = new ArrayList<AutoCloseable>();

        private CompositeBuffer() {
        }

        public void addBuffer(AutoCloseable buffer) {
            this.buffers.add(buffer);
        }

        @Override
        public void close() {
            IOUtils.closeAllUnchecked(this.buffers);
        }
    }

    private static class RecordingConflictDetector<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
    extends ConflictDetectingValueMerger<KEY, VALUE, KEY> {
        private final IndexKeyStorage<KEY> allConflictingKeys;

        RecordingConflictDetector(boolean compareEntityIds, IndexKeyStorage<KEY> indexKeyStorage) {
            super(compareEntityIds);
            this.allConflictingKeys = indexKeyStorage;
        }

        @Override
        void doReportConflict(long existingNodeId, long addedNodeId, KEY conflictingKey) {
            try {
                this.allConflictingKeys.add(conflictingKey);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        IndexKeyStorage.KeyEntryCursor<KEY> allConflicts() throws IOException {
            this.allConflictingKeys.doneAdding();
            return (IndexKeyStorage.KeyEntryCursor)this.allConflictingKeys.reader();
        }

        void relaxUniqueness(KEY key) {
            ((NativeIndexKey)((Object)key)).setCompareId(true);
        }
    }

    private static class CloseCancellation
    implements BlockStorage.Cancellation {
        private volatile boolean cancelled;

        private CloseCancellation() {
        }

        void setCancel() {
            this.cancelled = true;
        }

        @Override
        public boolean cancelled() {
            return this.cancelled;
        }
    }

    private class ThreadLocalBlockStorage
    extends BlockStorage.Monitor.Delegate {
        private final BlockStorage<KEY, VALUE> blockStorage;
        private volatile long count;
        private volatile boolean mergeStarted;
        private volatile long totalEntriesToMerge;
        private final AtomicLong entriesMerged;

        ThreadLocalBlockStorage(int id) throws IOException {
            super(BlockBasedIndexPopulator.this.blockStorageMonitor);
            this.entriesMerged = new AtomicLong();
            File storeFile = BlockBasedIndexPopulator.this.indexFiles.getStoreFile();
            File blockFile = new File(storeFile.getParentFile(), storeFile.getName() + ".scan-" + id);
            this.blockStorage = new BlockStorage(BlockBasedIndexPopulator.this.layout, BlockBasedIndexPopulator.this.bufferFactory, BlockBasedIndexPopulator.this.fileSystem, blockFile, this, BlockBasedIndexPopulator.this.memoryTracker);
        }

        @Override
        public void mergeStarted(long entryCount, long totalEntriesToWriteDuringMerge) {
            super.mergeStarted(entryCount, totalEntriesToWriteDuringMerge);
            this.count = entryCount;
            this.totalEntriesToMerge = totalEntriesToWriteDuringMerge;
            this.mergeStarted = true;
        }

        @Override
        public void entriesMerged(int entries) {
            super.entriesMerged(entries);
            this.entriesMerged.addAndGet(entries);
        }
    }
}

