/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.internal;

import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.impl.coreapi.internal.NodeFactory;
import org.neo4j.kernel.impl.coreapi.internal.PrefetchingNodeResourceIterator;

public class NodeLabelPropertyIterator
extends PrefetchingNodeResourceIterator {
    private final Read read;
    private final NodeLabelIndexCursor nodeLabelCursor;
    private final NodeCursor nodeCursor;
    private final PropertyCursor propertyCursor;
    private final IndexQuery[] queries;

    public NodeLabelPropertyIterator(Read read, NodeLabelIndexCursor nodeLabelCursor, NodeCursor nodeCursor, PropertyCursor propertyCursor, NodeFactory nodeFactory, IndexQuery ... queries) {
        super(nodeFactory);
        this.read = read;
        this.nodeLabelCursor = nodeLabelCursor;
        this.nodeCursor = nodeCursor;
        this.propertyCursor = propertyCursor;
        this.queries = queries;
    }

    @Override
    protected long fetchNext() {
        boolean hasNext;
        while ((hasNext = this.nodeLabelCursor.next()) && !this.hasPropertiesWithValues()) {
        }
        if (hasNext) {
            return this.nodeLabelCursor.nodeReference();
        }
        this.close();
        return -1L;
    }

    @Override
    void closeResources() {
        IOUtils.closeAllSilently((AutoCloseable[])new Cursor[]{this.nodeLabelCursor, this.nodeCursor, this.propertyCursor});
    }

    private boolean hasPropertiesWithValues() {
        int targetCount = this.queries.length;
        this.read.singleNode(this.nodeLabelCursor.nodeReference(), this.nodeCursor);
        if (this.nodeCursor.next()) {
            this.nodeCursor.properties(this.propertyCursor);
            while (this.propertyCursor.next()) {
                for (IndexQuery query : this.queries) {
                    if (this.propertyCursor.propertyKey() != query.propertyKeyId()) continue;
                    if (query.acceptsValueAt(this.propertyCursor)) {
                        if (--targetCount != 0) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }
}

