/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.constraints;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StandardConstraintRuleAccessor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class StandardConstraintSemantics
extends ConstraintSemantics {
    public static final String ERROR_MESSAGE_EXISTS = "Property existence constraint requires Neo4j Enterprise Edition";
    public static final String ERROR_MESSAGE_NODE_KEY = "Node Key constraint requires Neo4j Enterprise Edition";
    protected final StandardConstraintRuleAccessor accessor = new StandardConstraintRuleAccessor();

    public StandardConstraintSemantics() {
        this(1);
    }

    protected StandardConstraintSemantics(int priority) {
        super(priority);
    }

    public String getName() {
        return "standardConstraints";
    }

    @Override
    public void validateNodeKeyConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw this.nodeKeyConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public void validateNodePropertyExistenceConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(RelationshipTypeIndexCursor allRelationships, RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor);
    }

    public ConstraintDescriptor readConstraint(ConstraintDescriptor constraint) {
        switch (constraint.type()) {
            case EXISTS: {
                return this.readNonStandardConstraint(constraint, ERROR_MESSAGE_EXISTS);
            }
            case UNIQUE_EXISTS: {
                return this.readNonStandardConstraint(constraint, ERROR_MESSAGE_NODE_KEY);
            }
        }
        return constraint;
    }

    protected ConstraintDescriptor readNonStandardConstraint(ConstraintDescriptor constraint, String errorMessage) {
        throw new IllegalStateException(errorMessage);
    }

    private CreateConstraintFailureException propertyExistenceConstraintsNotAllowed(SchemaDescriptor descriptor) {
        return new CreateConstraintFailureException(ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)descriptor), ERROR_MESSAGE_EXISTS);
    }

    private CreateConstraintFailureException nodeKeyConstraintsNotAllowed(SchemaDescriptor descriptor) {
        return new CreateConstraintFailureException(ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)descriptor), ERROR_MESSAGE_NODE_KEY);
    }

    public ConstraintDescriptor createUniquenessConstraintRule(long ruleId, UniquenessConstraintDescriptor descriptor, long indexId) {
        return this.accessor.createUniquenessConstraintRule(ruleId, descriptor, indexId);
    }

    public ConstraintDescriptor createNodeKeyConstraintRule(long ruleId, NodeKeyConstraintDescriptor descriptor, long indexId) throws CreateConstraintFailureException {
        throw this.nodeKeyConstraintsNotAllowed(descriptor.schema());
    }

    public ConstraintDescriptor createExistenceConstraint(long ruleId, ConstraintDescriptor descriptor) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(descriptor.schema());
    }

    @Override
    public TxStateVisitor decorateTxStateVisitor(StorageReader storageReader, Read read, CursorFactory cursorFactory, ReadableTransactionState state, TxStateVisitor visitor, PageCursorTracer pageCursorTracer, MemoryTracker memoryTracker) {
        return visitor;
    }
}

