/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.monitor;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public class KernelTransactionMonitor
extends TransactionMonitor {
    private final KernelTransactions kernelTransactions;

    public KernelTransactionMonitor(KernelTransactions kernelTransactions, SystemNanoClock clock, LogService logService) {
        super(clock, logService);
        this.kernelTransactions = kernelTransactions;
    }

    @Override
    protected Set<TransactionMonitor.MonitoredTransaction> getActiveTransactions() {
        return this.kernelTransactions.activeTransactions().stream().map(MonitoredKernelTransaction::new).collect(Collectors.toSet());
    }

    private static class MonitoredKernelTransaction
    implements TransactionMonitor.MonitoredTransaction {
        private final KernelTransactionHandle kernelTransaction;

        MonitoredKernelTransaction(KernelTransactionHandle kernelTransaction) {
            this.kernelTransaction = kernelTransaction;
        }

        @Override
        public long startTimeNanos() {
            return this.kernelTransaction.startTimeNanos();
        }

        @Override
        public long timeoutNanos() {
            return TimeUnit.MILLISECONDS.toNanos(this.kernelTransaction.timeoutMillis());
        }

        @Override
        public boolean isSchemaTransaction() {
            return this.kernelTransaction.isSchemaTransaction();
        }

        @Override
        public boolean markForTermination(Status reason) {
            return this.kernelTransaction.markForTermination(reason);
        }
    }
}

