/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.util.DurationLogger;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class OnlineIndexSamplingJob
implements IndexSamplingJob {
    private static final String INDEX_SAMPLER_TAG = "indexSampler";
    private final long indexId;
    private final IndexProxy indexProxy;
    private final IndexStatisticsStore indexStatisticsStore;
    private final Log log;
    private final String indexUserDescription;
    private final PageCacheTracer pageCacheTracer;

    OnlineIndexSamplingJob(long indexId, IndexProxy indexProxy, IndexStatisticsStore indexStatisticsStore, String indexUserDescription, LogProvider logProvider, PageCacheTracer pageCacheTracer) {
        this.indexId = indexId;
        this.indexProxy = indexProxy;
        this.indexStatisticsStore = indexStatisticsStore;
        this.log = logProvider.getLog(this.getClass());
        this.indexUserDescription = indexUserDescription;
        this.pageCacheTracer = pageCacheTracer;
    }

    @Override
    public long indexId() {
        return this.indexId;
    }

    @Override
    public void run() {
        try (DurationLogger durationLogger = new DurationLogger(this.log, "Sampling index " + this.indexUserDescription);){
            try (IndexReader reader = this.indexProxy.newReader();
                 PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(INDEX_SAMPLER_TAG);
                 IndexSampler sampler = reader.createSampler();){
                IndexSample sample = sampler.sampleIndex(cursorTracer);
                if (this.indexProxy.getState() == InternalIndexState.ONLINE) {
                    this.indexStatisticsStore.replaceStats(this.indexId, sample);
                    durationLogger.markAsFinished();
                    this.log.debug(String.format("Sampled index %s with %d unique values in sample of avg size %d taken from index containing %d entries", this.indexUserDescription, sample.uniqueValues(), sample.sampleSize(), sample.indexSize()));
                } else {
                    durationLogger.markAsAborted("Index no longer ONLINE");
                }
            }
            catch (IndexNotFoundKernelException e) {
                durationLogger.markAsAborted("Attempted to sample missing/already deleted index " + this.indexUserDescription);
            }
        }
    }
}

