/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.index.updater.UpdateCountingIndexUpdater;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class OnlineIndexProxy
implements IndexProxy {
    private final long indexId;
    private final IndexDescriptor descriptor;
    final IndexAccessor accessor;
    private final IndexStatisticsStore indexStatisticsStore;
    private boolean started;
    private final boolean forcedIdempotentMode;

    OnlineIndexProxy(IndexDescriptor descriptor, IndexAccessor accessor, IndexStatisticsStore indexStatisticsStore, boolean forcedIdempotentMode) {
        assert (accessor != null);
        this.indexId = descriptor.getId();
        this.descriptor = descriptor;
        this.accessor = accessor;
        this.indexStatisticsStore = indexStatisticsStore;
        this.forcedIdempotentMode = forcedIdempotentMode;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, PageCursorTracer cursorTracer) {
        IndexUpdater actual = this.accessor.newUpdater(this.escalateModeIfNecessary(mode), cursorTracer);
        return this.started ? this.updateCountingUpdater(actual) : actual;
    }

    private IndexUpdateMode escalateModeIfNecessary(IndexUpdateMode mode) {
        if (this.forcedIdempotentMode) {
            if (mode != IndexUpdateMode.ONLINE) {
                throw new IllegalArgumentException("Unexpected mode " + mode + " given that " + this + " has been marked with forced idempotent mode. Expected mode " + IndexUpdateMode.ONLINE);
            }
            return IndexUpdateMode.ONLINE_IDEMPOTENT;
        }
        return mode;
    }

    private IndexUpdater updateCountingUpdater(IndexUpdater indexUpdater) {
        return new UpdateCountingIndexUpdater(this.indexStatisticsStore, this.indexId, indexUpdater);
    }

    public void drop() {
        this.indexStatisticsStore.removeIndex(this.getDescriptor().getId());
        this.accessor.drop();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.ONLINE;
    }

    @Override
    public void force(IOLimiter ioLimiter, PageCursorTracer cursorTracer) {
        this.accessor.force(ioLimiter, cursorTracer);
    }

    @Override
    public void refresh() {
        this.accessor.refresh();
    }

    @Override
    public void close(PageCursorTracer cursorTracer) throws IOException {
        this.accessor.close();
    }

    @Override
    public IndexReader newReader() {
        return this.accessor.newReader();
    }

    @Override
    public boolean awaitStoreScanCompleted(long time, TimeUnit unit) {
        return false;
    }

    @Override
    public void activate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void validateBeforeCommit(Value[] tuple, long entityId) {
        this.accessor.validateBeforeCommit(entityId, tuple);
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is ONLINE");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return PopulationProgress.DONE;
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return this.accessor.snapshotFiles();
    }

    public Map<String, Value> indexConfig() {
        return this.accessor.indexConfig();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[accessor:" + this.accessor + ", descriptor:" + this.descriptor + "]";
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        this.accessor.verifyDeferredConstraints(nodePropertyAccessor);
    }

    @VisibleForTesting
    public IndexAccessor accessor() {
        return this.accessor;
    }
}

