/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.BufferingLog;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class KernelDiagnosticsOfflineReportProvider
extends DiagnosticsOfflineReportProvider {
    private FileSystemAbstraction fs;
    private Config config;
    private DatabaseLayout databaseLayout;

    public KernelDiagnosticsOfflineReportProvider() {
        super("logs", "plugins", "tree", "tx", "version");
    }

    @Override
    public void init(FileSystemAbstraction fs, String defaultDatabaseName, Config config, File storeDirectory) {
        this.fs = fs;
        this.config = config;
        this.databaseLayout = DatabaseLayout.ofFlat((File)storeDirectory);
    }

    @Override
    protected List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
        ArrayList<DiagnosticsReportSource> sources = new ArrayList<DiagnosticsReportSource>();
        if (classifiers.contains("logs")) {
            this.getLogFiles(sources);
        }
        if (classifiers.contains("plugins")) {
            this.listPlugins(sources);
        }
        if (classifiers.contains("tree")) {
            this.listDataDirectory(sources);
        }
        if (classifiers.contains("tx")) {
            this.getTransactionLogFiles(sources);
        }
        if (classifiers.contains("version")) {
            this.getVersion(sources);
        }
        return sources;
    }

    private void getVersion(List<DiagnosticsReportSource> sources) {
        Supplier<String> neo4jVersion = () -> "neo4j " + Version.getNeo4jVersion() + System.lineSeparator();
        sources.add(DiagnosticsReportSources.newDiagnosticsString("version.txt", neo4jVersion));
    }

    private void listPlugins(List<DiagnosticsReportSource> sources) {
        File pluginDirectory = ((Path)this.config.get(GraphDatabaseSettings.plugin_dir)).toFile();
        if (this.fs.fileExists(pluginDirectory)) {
            StringBuilder sb = new StringBuilder();
            sb.append("List of plugin directory:").append(System.lineSeparator());
            this.listContentOfDirectory(pluginDirectory, "  ", sb);
            sources.add(DiagnosticsReportSources.newDiagnosticsString("plugins.txt", sb::toString));
        }
    }

    private void listContentOfDirectory(File directory, String prefix, StringBuilder sb) {
        File[] files;
        if (!this.fs.isDirectory(directory)) {
            return;
        }
        for (File file : files = this.fs.listFiles(directory)) {
            if (this.fs.isDirectory(file)) {
                this.listContentOfDirectory(file, prefix + File.separator + file.getName(), sb);
                continue;
            }
            sb.append(prefix).append(file.getName()).append(System.lineSeparator());
        }
    }

    private void listDataDirectory(List<DiagnosticsReportSource> sources) {
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine();
        StoreFilesDiagnostics storeFiles = new StoreFilesDiagnostics(storageEngineFactory, this.fs, this.databaseLayout);
        BufferingLog logger = new BufferingLog();
        storeFiles.dump(logger.debugLogger());
        sources.add(DiagnosticsReportSources.newDiagnosticsString("tree.txt", () -> ((BufferingLog)logger).toString()));
    }

    private void getLogFiles(List<DiagnosticsReportSource> sources) {
        File gcRotationLog;
        File gcLog;
        File logDirectory;
        File neo4jLog;
        File debugLogFile = ((Path)this.config.get(GraphDatabaseSettings.store_internal_log_path)).toFile();
        if (this.fs.fileExists(debugLogFile)) {
            sources.addAll(DiagnosticsReportSources.newDiagnosticsRotatingFile("logs/debug.log", this.fs, debugLogFile));
        }
        if (this.fs.fileExists(neo4jLog = new File(logDirectory = ((Path)this.config.get(GraphDatabaseSettings.logs_directory)).toFile(), "neo4j.log"))) {
            sources.add(DiagnosticsReportSources.newDiagnosticsFile("logs/neo4j.log", this.fs, neo4jLog));
        }
        if (this.fs.fileExists(gcLog = new File(logDirectory, "gc.log"))) {
            sources.add(DiagnosticsReportSources.newDiagnosticsFile("logs/gc.log", this.fs, gcLog));
        }
        int i = 0;
        while (this.fs.fileExists(gcRotationLog = new File(logDirectory, "gc.log." + i))) {
            sources.add(DiagnosticsReportSources.newDiagnosticsFile("logs/gc.log." + i, this.fs, gcRotationLog));
            ++i;
        }
    }

    private void getTransactionLogFiles(List<DiagnosticsReportSource> sources) {
        try {
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder(this.databaseLayout.databaseDirectory(), this.fs).build();
            for (File file : logFiles.logFiles()) {
                sources.add(DiagnosticsReportSources.newDiagnosticsFile("tx/" + file.getName(), this.fs, file));
            }
        }
        catch (IOException e) {
            sources.add(DiagnosticsReportSources.newDiagnosticsString("tx.txt", () -> "Error getting tx logs: " + e.getMessage()));
        }
    }
}

