/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;

public class SystemGraphComponents
implements SystemGraphComponent {
    private final HashMap<String, SystemGraphComponent> componentMap = new HashMap();
    private final ArrayList<SystemGraphComponent> components = new ArrayList();
    public static final SystemGraphComponents NO_OP = new SystemGraphComponents(){

        @Override
        public void register(SystemGraphComponent initializer) {
        }
    };

    public void register(SystemGraphComponent initializer) {
        this.deregister(initializer.component());
        this.componentMap.put(initializer.component(), initializer);
        this.components.add(initializer);
    }

    public void deregister(String key) {
        SystemGraphComponent removed = this.componentMap.remove(key);
        if (removed != null) {
            this.components.remove(removed);
        }
    }

    public void forEach(Consumer<SystemGraphComponent> process) {
        this.components.forEach(process);
    }

    @Override
    public String component() {
        return "system-graph";
    }

    @Override
    public SystemGraphComponent.Status detect(Transaction tx) {
        return this.components.stream().map(c -> c.detect(tx)).reduce(SystemGraphComponent.Status::with).orElse(SystemGraphComponent.Status.CURRENT);
    }

    @Override
    public Optional<Exception> initializeSystemGraph(GraphDatabaseService system) {
        assert (system.databaseName().equals("system"));
        List<Pair> errors = this.components.stream().flatMap(c -> c.initializeSystemGraph(system).stream().map(e -> Pair.of((Object)c, (Object)e))).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                Pair e2 = (Pair)errors.get(0);
                return Optional.of(new IllegalStateException(String.format("Failed to %s system graph component '%s': %s", "initialize", ((SystemGraphComponent)e2.first()).component(), ((Exception)e2.other()).getMessage()), (Throwable)e2.other()));
            }
            StringBuilder sb = new StringBuilder(String.format("Multiple components failed to %s the system graph:", "initialize"));
            errors.forEach((? super T e) -> sb.append("\n\t").append(((SystemGraphComponent)e.first()).component()).append(": ").append(((Exception)e.other()).toString()));
            return Optional.of(new IllegalStateException(sb.toString()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Exception> upgradeToCurrent(GraphDatabaseService system) {
        ArrayList componentsToUpgrade = new ArrayList();
        SystemGraphComponent.executeWithFullAccess(system, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> this.components.stream().filter(c -> {
            SystemGraphComponent.Status status = c.detect((Transaction)tx);
            return status == SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE || status == SystemGraphComponent.Status.REQUIRES_UPGRADE;
        }).forEach(componentsToUpgrade::add)));
        ArrayList errors = new ArrayList();
        for (SystemGraphComponent component : componentsToUpgrade) {
            Optional<Exception> exception = component.upgradeToCurrent(system);
            exception.ifPresent(errors::add);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                return Optional.of((Exception)errors.get(0));
            }
            StringBuilder sb = new StringBuilder(String.format("Multiple components failed to %s the system graph:", "upgrade"));
            errors.forEach((? super T e) -> sb.append("\n\t").append(e.toString()));
            return Optional.of(new IllegalStateException(sb.toString()));
        }
        return Optional.empty();
    }
}

