/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.storemigration.LegacyDatabaseLayout;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.log.LogVersionUpgradeChecker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionMetaDataStore;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;

public class LogsUpgrader {
    private final FileSystemAbstraction fs;
    private final StorageEngineFactory storageEngineFactory;
    private final DatabaseLayout databaseLayout;
    private final PageCache pageCache;
    private final LegacyTransactionLogsLocator legacyLogsLocator;
    private final Config config;
    private final DependencyResolver dependencyResolver;
    private final PageCacheTracer tracer;
    private final MemoryTracker memoryTracker;
    private final boolean isUpgradeAllowed;
    private final Map<DatabaseLayout, LogTailScanner> tailScanners;
    private final Monitors monitors;

    public LogsUpgrader(FileSystemAbstraction fs, StorageEngineFactory storageEngineFactory, DatabaseLayout databaseLayout, PageCache pageCache, LegacyTransactionLogsLocator legacyLogsLocator, Config config, DependencyResolver dependencyResolver, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this.fs = fs;
        this.storageEngineFactory = storageEngineFactory;
        this.databaseLayout = databaseLayout;
        this.pageCache = pageCache;
        this.legacyLogsLocator = legacyLogsLocator;
        this.config = config;
        this.dependencyResolver = dependencyResolver;
        this.tracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
        this.isUpgradeAllowed = (Boolean)config.get(GraphDatabaseSettings.allow_upgrade);
        this.tailScanners = new HashMap<DatabaseLayout, LogTailScanner>();
        this.monitors = (Monitors)dependencyResolver.resolveDependency(Monitors.class);
    }

    public void assertCleanlyShutDown(DatabaseLayout layout) {
        Throwable suppressibleException = null;
        try {
            DatabaseLayout oldDatabaseLayout = this.buildLegacyLogsLayout(layout);
            LogTailScanner logTailScanner = this.getLogTailScanner(oldDatabaseLayout);
            LogVersionUpgradeChecker.check(logTailScanner, this.isUpgradeAllowed);
            LogTailScanner.LogTailInformation tail = logTailScanner.getTailInformation();
            if (!tail.isRecoveryRequired()) {
                return;
            }
            if (tail.logsMissing()) {
                logTailScanner = this.getLogTailScanner(layout);
                LogVersionUpgradeChecker.check(logTailScanner, this.isUpgradeAllowed);
                tail = logTailScanner.getTailInformation();
                if (!tail.isRecoveryRequired()) {
                    return;
                }
                if (tail.logsMissing() && !((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            suppressibleException = throwable;
        }
        StoreUpgrader.DatabaseNotCleanlyShutDownException exception = new StoreUpgrader.DatabaseNotCleanlyShutDownException();
        if (suppressibleException != null) {
            exception.addSuppressed(suppressibleException);
        }
        throw exception;
    }

    public void assertLogVersionIsCurrent(DatabaseLayout layout) {
        layout = this.buildLegacyLogsLayout(layout);
        LogTailScanner logTailScanner = this.getLogTailScanner(layout);
        LogVersionUpgradeChecker.check(logTailScanner, this.isUpgradeAllowed);
    }

    private DatabaseLayout buildLegacyLogsLayout(DatabaseLayout databaseLayout) {
        return new LegacyDatabaseLayout(databaseLayout.getNeo4jLayout(), databaseLayout.getDatabaseName(), this.legacyLogsLocator);
    }

    private LogTailScanner getLogTailScanner(DatabaseLayout layout) {
        return this.tailScanners.computeIfAbsent(layout, this::buildLogTailScanner);
    }

    private LogTailScanner buildLogTailScanner(DatabaseLayout layout) {
        LogFiles logFiles;
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        try {
            logFiles = LogFilesBuilder.builder(layout, this.fs).withLogEntryReader((LogEntryReader)logEntryReader).withConfig(this.config).withDependencies(this.dependencyResolver).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        boolean failOnCorruptedLogFiles = (Boolean)this.config.get(GraphDatabaseInternalSettings.fail_on_corrupted_log_files);
        return new LogTailScanner(logFiles, (LogEntryReader)logEntryReader, this.monitors, failOnCorruptedLogFiles, this.memoryTracker);
    }

    public void upgrade(DatabaseLayout layout) {
        CommandReaderFactory commandReaderFactory = this.storageEngineFactory.commandReaderFactory();
        try (TransactionMetaDataStore store = this.getMetaDataStore();){
            TransactionLogInitializer logInitializer = new TransactionLogInitializer(this.fs, store, commandReaderFactory, this.tracer);
            File transactionLogsDirectory = layout.getTransactionLogsDirectory();
            File legacyLogsDirectory = this.legacyLogsLocator.getTransactionLogsDirectory();
            boolean filesNeedsToMove = !transactionLogsDirectory.equals(legacyLogsDirectory);
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder(legacyLogsDirectory, this.fs).withCommandReaderFactory(commandReaderFactory).build();
            File[] legacyFiles = logFiles.logFiles();
            if (legacyFiles != null && legacyFiles.length > 0) {
                if (filesNeedsToMove) {
                    for (File legacyFile : legacyFiles) {
                        this.fs.copyFile(legacyFile, new File(transactionLogsDirectory, legacyFile.getName()), FileSystemAbstraction.EMPTY_COPY_OPTIONS);
                    }
                }
                logInitializer.initializeExistingLogFiles(layout, transactionLogsDirectory);
                if (filesNeedsToMove) {
                    for (File legacyFile : legacyFiles) {
                        this.fs.deleteFile(legacyFile);
                    }
                }
            } else {
                logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder(transactionLogsDirectory, this.fs).build();
                legacyFiles = logFiles.logFiles();
                if (legacyFiles != null && legacyFiles.length > 0) {
                    logInitializer.initializeExistingLogFiles(layout, transactionLogsDirectory);
                } else {
                    if (((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                        throw new UpgradeNotAllowedException();
                    }
                    logInitializer.initializeEmptyLogFile(layout, transactionLogsDirectory);
                }
            }
        }
        catch (Exception exception) {
            throw new StoreUpgrader.TransactionLogsRelocationException("Failure on attempt to move transaction logs into new location.", exception);
        }
    }

    private TransactionMetaDataStore getMetaDataStore() throws IOException {
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (Object)true);
        return this.storageEngineFactory.transactionMetaDataStore(this.fs, this.databaseLayout, readOnlyConfig, this.pageCache, this.tracer);
    }
}

