/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import org.eclipse.collections.api.factory.Sets;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

abstract class NativeIndex<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements ConsistencyCheckable {
    final PageCache pageCache;
    final IndexFiles indexFiles;
    final IndexLayout<KEY, VALUE> layout;
    final FileSystemAbstraction fileSystem;
    final IndexDescriptor descriptor;
    private final IndexProvider.Monitor monitor;
    private final GBPTree.Monitor treeMonitor;
    private final boolean readOnly;
    protected GBPTree<KEY, VALUE> tree;

    NativeIndex(DatabaseIndexContext databaseIndexContext, IndexLayout<KEY, VALUE> layout, IndexFiles indexFiles, IndexDescriptor descriptor, GBPTree.Monitor treeMonitor) {
        this.pageCache = databaseIndexContext.pageCache;
        this.fileSystem = databaseIndexContext.fileSystem;
        this.monitor = databaseIndexContext.monitor;
        this.readOnly = databaseIndexContext.readOnly;
        this.indexFiles = indexFiles;
        this.layout = layout;
        this.descriptor = descriptor;
        this.treeMonitor = treeMonitor;
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Consumer<PageCursor> headerWriter) {
        this.ensureDirectoryExist();
        GBPTree.Monitor monitor = this.treeMonitor();
        File storeFile = this.indexFiles.getStoreFile();
        this.tree = new GBPTree(this.pageCache, storeFile, this.layout, 0, monitor, GBPTree.NO_HEADER_READER, headerWriter, recoveryCleanupWorkCollector, this.readOnly, PageCacheTracer.NULL, Sets.immutable.empty());
        this.afterTreeInstantiation(this.tree);
    }

    protected void afterTreeInstantiation(GBPTree<KEY, VALUE> tree) {
    }

    private GBPTree.Monitor treeMonitor() {
        return new NativeIndexTreeMonitor();
    }

    private void ensureDirectoryExist() {
        this.indexFiles.ensureDirectoryExist();
    }

    void closeTree() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
        this.tree = null;
    }

    void assertOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Index has been closed");
        }
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, PageCursorTracer cursorTracer) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class), cursorTracer);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<KEY> visitor, PageCursorTracer cursorTracer) {
        try {
            return this.tree.consistencyCheck(visitor, cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class NativeIndexTreeMonitor
    extends GBPTree.Monitor.Delegate {
        NativeIndexTreeMonitor() {
            super(NativeIndex.this.treeMonitor);
        }

        public void cleanupRegistered() {
            NativeIndex.this.monitor.recoveryCleanupRegistered(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor);
            super.cleanupRegistered();
        }

        public void cleanupStarted() {
            NativeIndex.this.monitor.recoveryCleanupStarted(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor);
            super.cleanupStarted();
        }

        public void cleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
            NativeIndex.this.monitor.recoveryCleanupFinished(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor, numberOfPagesVisited, numberOfTreeNodes, numberOfCleanedCrashPointers, durationMillis);
            super.cleanupFinished(numberOfPagesVisited, numberOfTreeNodes, numberOfCleanedCrashPointers, durationMillis);
        }

        public void cleanupClosed() {
            NativeIndex.this.monitor.recoveryCleanupClosed(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor);
            super.cleanupClosed();
        }

        public void cleanupFailed(Throwable throwable) {
            NativeIndex.this.monitor.recoveryCleanupFailed(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor, throwable);
            super.cleanupFailed(throwable);
        }
    }
}

