/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;

public class IndexReaderCache {
    private final Map<IndexDescriptor, IndexReader> indexReaders;
    private final IndexingService indexingService;

    public IndexReaderCache(IndexingService indexingService) {
        this.indexingService = indexingService;
        this.indexReaders = new HashMap<IndexDescriptor, IndexReader>();
    }

    public IndexReader getOrCreate(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexReader reader = this.indexReaders.get(descriptor);
        if (reader == null) {
            reader = this.newUnCachedReader(descriptor);
            this.indexReaders.put(descriptor, reader);
        }
        return reader;
    }

    public IndexReader newUnCachedReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy index = this.indexingService.getIndexProxy(descriptor);
        return index.newReader();
    }

    public void close() {
        if (this.indexReaders.isEmpty()) {
            return;
        }
        for (IndexReader indexReader : this.indexReaders.values()) {
            indexReader.close();
        }
        this.indexReaders.clear();
    }
}

