/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.storemigration.FulltextConfigExtractor;
import org.neo4j.kernel.impl.storemigration.GenericConfigExtractor;
import org.neo4j.kernel.impl.storemigration.SpatialConfigExtractor;
import org.neo4j.kernel.impl.storemigration.SpatialFile;
import org.neo4j.logging.Log;
import org.neo4j.values.storable.CoordinateReferenceSystem;

enum IndexMigration {
    LUCENE("lucene", "1.0", IndexMigration.asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE30), true){

        @Override
        File[] providerRootDirectories(DatabaseLayout layout) {
            File luceneDir = IndexMigration.directoryRootByProviderKey(layout.databaseDirectory(), this.providerKey);
            File lucene10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new File[]{luceneDir, lucene10Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, PageCursorTracer cursorTracer, Log log) throws IOException {
            File lucene10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            File spatialDirectory = IndexMigration.getSpatialSubDirectory(indexId, lucene10Dir);
            List<SpatialFile> spatialFiles = 1.getSpatialFiles(fs, spatialDirectory);
            return SpatialConfigExtractor.indexConfigFromSpatialFile(pageCache, spatialFiles, cursorTracer, log);
        }
    }
    ,
    NATIVE10("lucene+native", "1.0", IndexMigration.asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE30), true){

        @Override
        File[] providerRootDirectories(DatabaseLayout layout) {
            File luceneNative10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new File[]{luceneNative10Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, PageCursorTracer cursorTracer, Log log) throws IOException {
            File providerRootDirectory = this.providerRootDirectories(layout)[0];
            File spatialDirectory = IndexMigration.getSpatialSubDirectory(indexId, providerRootDirectory);
            List<SpatialFile> spatialFiles = 2.getSpatialFiles(fs, spatialDirectory);
            return SpatialConfigExtractor.indexConfigFromSpatialFile(pageCache, spatialFiles, cursorTracer, log);
        }
    }
    ,
    NATIVE20("lucene+native", "2.0", IndexMigration.asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10), true){

        @Override
        File[] providerRootDirectories(DatabaseLayout layout) {
            File luceneNative20Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new File[]{luceneNative20Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, PageCursorTracer cursorTracer, Log log) throws IOException {
            File providerRootDirectory = this.providerRootDirectories(layout)[0];
            File spatialDirectory = IndexMigration.getSpatialSubDirectory(indexId, providerRootDirectory);
            List<SpatialFile> spatialFiles = 3.getSpatialFiles(fs, spatialDirectory);
            return SpatialConfigExtractor.indexConfigFromSpatialFile(pageCache, spatialFiles, cursorTracer, log);
        }
    }
    ,
    NATIVE_BTREE10(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerKey(), GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion(), IndexMigration.asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10), false){

        @Override
        File[] providerRootDirectories(DatabaseLayout layout) {
            File nativeBtree10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new File[]{nativeBtree10Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, PageCursorTracer cursorTracer, Log log) throws IOException {
            File rootDir = this.providerRootDirectories(layout)[0];
            File genericFile = FileUtils.path((File)rootDir, (String[])new String[]{String.valueOf(indexId), "index-" + indexId});
            return GenericConfigExtractor.indexConfigFromGenericFile(fs, pageCache, genericFile, cursorTracer, log);
        }
    }
    ,
    FULLTEXT10("fulltext", "1.0", new IndexProviderDescriptor("fulltext", "1.0"), false){

        @Override
        File[] providerRootDirectories(DatabaseLayout layout) {
            File fulltext10Dir = IndexMigration.directoryRootByProviderKeyAndVersion(layout.databaseDirectory(), this.providerKey, this.providerVersion);
            return new File[]{fulltext10Dir};
        }

        @Override
        IndexConfig extractIndexConfig(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, long indexId, PageCursorTracer cursorTracer, Log log) {
            File fulltext10Dir = this.providerRootDirectories(layout)[0];
            File directoryForIndex = FileUtils.path((File)fulltext10Dir, (String[])new String[]{String.valueOf(indexId)});
            File fulltextIndexDirectory = IndexMigration.directoryBySubProvider(directoryForIndex, this.providerKey, this.providerVersion);
            return FulltextConfigExtractor.indexConfigFromFulltextDirectory(fs, fulltextIndexDirectory);
        }
    };

    private static final Pattern CRS_FILE_PATTERN;
    private static final String SPATIAL_DIRECTORY_NAME = "spatial-1.0";
    final String providerKey;
    final String providerVersion;
    final IndexProviderDescriptor desiredAlternativeProvider;
    private final boolean retired;

    private IndexMigration(String providerKey, String providerVersion, IndexProviderDescriptor desiredAlternativeProvider, boolean retired) {
        this.providerKey = providerKey;
        this.providerVersion = providerVersion;
        this.desiredAlternativeProvider = desiredAlternativeProvider;
        this.retired = retired;
    }

    abstract File[] providerRootDirectories(DatabaseLayout var1);

    abstract IndexConfig extractIndexConfig(FileSystemAbstraction var1, PageCache var2, DatabaseLayout var3, long var4, PageCursorTracer var6, Log var7) throws IOException;

    private static File baseSchemaIndexFolder(File databaseStoreDir) {
        return FileUtils.path((File)databaseStoreDir, (String[])new String[]{"schema", "index"});
    }

    private static File directoryRootByProviderKey(File databaseStoreDir, String providerKey) {
        return FileUtils.path((File)IndexMigration.baseSchemaIndexFolder(databaseStoreDir), (String[])new String[]{IndexMigration.fileNameFriendly(providerKey)});
    }

    private static File directoryRootByProviderKeyAndVersion(File databaseStoreDir, String providerKey, String providerVersion) {
        return FileUtils.path((File)IndexMigration.baseSchemaIndexFolder(databaseStoreDir), (String[])new String[]{IndexMigration.fileNameFriendly(providerKey + "-" + providerVersion)});
    }

    private static File directoryBySubProvider(File parentProviderDir, String providerKey, String providerVersion) {
        return FileUtils.path((File)parentProviderDir, (String[])new String[]{IndexMigration.fileNameFriendly(providerKey + "-" + providerVersion)});
    }

    private static String fileNameFriendly(String name) {
        return name.replaceAll("\\+", "_");
    }

    public static IndexMigration migrationFromOldProvider(String providerKey, String providerVersion) {
        for (IndexMigration provider : IndexMigration.values()) {
            if (!provider.providerKey.equals(providerKey) || !provider.providerVersion.equals(providerVersion)) continue;
            return provider;
        }
        throw new IllegalArgumentException("Can not find old index provider " + providerKey + "-" + providerVersion);
    }

    public static IndexMigration[] retired() {
        return (IndexMigration[])Arrays.stream(IndexMigration.values()).filter(p -> p.retired).toArray(IndexMigration[]::new);
    }

    public static IndexMigration[] nonRetired() {
        return (IndexMigration[])Arrays.stream(IndexMigration.values()).filter(p -> !p.retired).toArray(IndexMigration[]::new);
    }

    private static File getSpatialSubDirectory(long indexId, File baseProviderDir) {
        return FileUtils.path((File)baseProviderDir, (String[])new String[]{String.valueOf(indexId), SPATIAL_DIRECTORY_NAME});
    }

    public static List<SpatialFile> getSpatialFiles(FileSystemAbstraction fs, File spatialDirectory) {
        ArrayList<SpatialFile> spatialFiles = new ArrayList<SpatialFile>();
        File[] files = fs.listFiles(spatialDirectory);
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                Matcher matcher = CRS_FILE_PATTERN.matcher(name);
                if (!matcher.matches()) continue;
                int tableId = Integer.parseInt(matcher.group(1));
                int code = Integer.parseInt(matcher.group(2));
                CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)tableId, (int)code);
                spatialFiles.add(new SpatialFile(crs, file));
            }
        }
        return spatialFiles;
    }

    private static IndexProviderDescriptor asIndexProviderDescriptor(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        return new IndexProviderDescriptor(schemaIndex.providerKey(), schemaIndex.providerVersion());
    }

    static {
        CRS_FILE_PATTERN = Pattern.compile("(\\d+)-(\\d+)");
    }
}

