/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;
import org.neo4j.kernel.impl.index.schema.NativeMinimalIndexAccessor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;

abstract class NativeIndexProvider<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue, LAYOUT extends IndexLayout<KEY, VALUE>>
extends IndexProvider {
    protected final DatabaseIndexContext databaseIndexContext;
    protected final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;

    protected NativeIndexProvider(DatabaseIndexContext databaseIndexContext, IndexProviderDescriptor descriptor, IndexDirectoryStructure.Factory directoryStructureFactory, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        super(descriptor, directoryStructureFactory);
        this.databaseIndexContext = databaseIndexContext;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
    }

    abstract LAYOUT layout(IndexDescriptor var1, File var2);

    public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor) {
        return new NativeMinimalIndexAccessor(descriptor, this.indexFiles(descriptor));
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup) {
        if (this.databaseIndexContext.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        IndexFiles indexFiles = this.indexFiles(descriptor);
        return this.newIndexPopulator(indexFiles, this.layout(descriptor, null), descriptor, bufferFactory, memoryTracker, tokenNameLookup);
    }

    protected abstract IndexPopulator newIndexPopulator(IndexFiles var1, LAYOUT var2, IndexDescriptor var3, ByteBufferFactory var4, MemoryTracker var5, TokenNameLookup var6);

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) throws IOException {
        IndexFiles indexFiles = this.indexFiles(descriptor);
        return this.newIndexAccessor(indexFiles, this.layout(descriptor, indexFiles.getStoreFile()), descriptor, tokenNameLookup);
    }

    protected abstract IndexAccessor newIndexAccessor(IndexFiles var1, LAYOUT var2, IndexDescriptor var3, TokenNameLookup var4) throws IOException;

    public String getPopulationFailure(IndexDescriptor descriptor, PageCursorTracer cursorTracer) {
        try {
            String failureMessage = NativeIndexes.readFailureMessage(this.databaseIndexContext.pageCache, this.storeFile(descriptor), cursorTracer);
            return (String)StringUtils.defaultIfEmpty((CharSequence)failureMessage, (CharSequence)"");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor, PageCursorTracer cursorTracer) {
        try {
            return NativeIndexes.readState(this.databaseIndexContext.pageCache, this.storeFile(descriptor), cursorTracer);
        }
        catch (IOException | MetadataMismatchException e) {
            this.databaseIndexContext.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
            return InternalIndexState.POPULATING;
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private File storeFile(IndexDescriptor descriptor) {
        IndexFiles indexFiles = this.indexFiles(descriptor);
        return indexFiles.getStoreFile();
    }

    private IndexFiles indexFiles(IndexDescriptor descriptor) {
        return new IndexFiles(this.databaseIndexContext.fileSystem, this.directoryStructure(), descriptor.getId());
    }
}

