/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.util.collection.CachingOffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.kernel.impl.util.collection.MutableLinearProbeLongHashSet;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapMemoryAllocator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class MutableLinearProbeLongHashSetTest {
    @Inject
    private RandomRule rnd;
    private final CachingOffHeapBlockAllocator blockAllocator = new CachingOffHeapBlockAllocator();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final MemoryAllocator memoryAllocator = new OffHeapMemoryAllocator((OffHeapBlockAllocator)this.blockAllocator);
    private MutableLinearProbeLongHashSet set = new MutableLinearProbeLongHashSet(this.memoryAllocator, this.memoryTracker);

    MutableLinearProbeLongHashSetTest() {
    }

    @AfterEach
    void afterEach() {
        this.set.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedNativeMemory(), (String)"Leaking memory");
        this.blockAllocator.release();
    }

    @Test
    void addRemoveContains() {
        this.set = (MutableLinearProbeLongHashSet)Mockito.spy((Object)this.set);
        Assertions.assertFalse((boolean)this.set.contains(0L));
        Assertions.assertTrue((boolean)this.set.add(0L));
        Assertions.assertTrue((boolean)this.set.contains(0L));
        Assertions.assertFalse((boolean)this.set.add(0L));
        Assertions.assertEquals((int)1, (int)this.set.size());
        Assertions.assertFalse((boolean)this.set.contains(1L));
        Assertions.assertTrue((boolean)this.set.add(1L));
        Assertions.assertTrue((boolean)this.set.contains(1L));
        Assertions.assertFalse((boolean)this.set.add(1L));
        Assertions.assertEquals((int)2, (int)this.set.size());
        Assertions.assertFalse((boolean)this.set.contains(2L));
        Assertions.assertTrue((boolean)this.set.add(2L));
        Assertions.assertTrue((boolean)this.set.contains(2L));
        Assertions.assertFalse((boolean)this.set.add(2L));
        Assertions.assertEquals((int)3, (int)this.set.size());
        Assertions.assertFalse((boolean)this.set.contains(3L));
        Assertions.assertFalse((boolean)this.set.remove(3L));
        Assertions.assertEquals((int)3, (int)this.set.size());
        Assertions.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{0L, 1L, 2L}), (Object)this.set);
        Assertions.assertTrue((boolean)this.set.remove(0L));
        Assertions.assertFalse((boolean)this.set.contains(0L));
        Assertions.assertEquals((int)2, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.remove(1L));
        Assertions.assertFalse((boolean)this.set.contains(1L));
        Assertions.assertEquals((int)1, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.remove(2L));
        Assertions.assertFalse((boolean)this.set.contains(2L));
        Assertions.assertEquals((int)0, (int)this.set.size());
    }

    @Test
    void addRemoveAll() {
        this.set.addAll(new long[]{1L, 2L, 3L, 1L, 2L, 3L, 100L, 200L, 300L});
        Assertions.assertEquals((int)6, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.containsAll(new long[]{100L, 200L, 300L, 1L, 2L, 3L}));
        this.set.removeAll(new long[]{1L, 2L, 100L, 200L});
        Assertions.assertEquals((int)2, (int)this.set.size());
        Assertions.assertTrue((boolean)this.set.containsAll(new long[]{300L, 3L}));
        this.set.removeAll(new long[]{3L, 300L});
        Assertions.assertEquals((int)0, (int)this.set.size());
    }

    @Test
    void clear() {
        this.set.addAll(new long[]{1L, 2L, 3L});
        Assertions.assertEquals((int)3, (int)this.set.size());
        this.set.clear();
        Assertions.assertEquals((int)0, (int)this.set.size());
        this.set.clear();
        Assertions.assertEquals((int)0, (int)this.set.size());
        this.set.addAll(new long[]{4L, 5L, 6L});
        Assertions.assertEquals((int)3, (int)this.set.size());
        this.set.clear();
        Assertions.assertEquals((int)0, (int)this.set.size());
    }

    @Test
    void grow() {
        this.set = (MutableLinearProbeLongHashSet)Mockito.spy((Object)this.set);
        for (int i = 0; i < 32; ++i) {
            Assertions.assertTrue((boolean)this.set.add((long)(100 + i)));
        }
        ((MutableLinearProbeLongHashSet)Mockito.verify((Object)this.set)).growAndRehash();
    }

    @Test
    void rehashWhenTooManyRemovals() {
        int i;
        this.set = (MutableLinearProbeLongHashSet)Mockito.spy((Object)this.set);
        int numOfElements = 16;
        int removalsToTriggerRehashing = 8;
        for (i = 0; i < 16; ++i) {
            Assertions.assertTrue((boolean)this.set.add((long)(100 + i)));
        }
        Assertions.assertEquals((int)16, (int)this.set.size());
        ((MutableLinearProbeLongHashSet)Mockito.verify((Object)this.set, (VerificationMode)Mockito.never())).rehashWithoutGrow();
        ((MutableLinearProbeLongHashSet)Mockito.verify((Object)this.set, (VerificationMode)Mockito.never())).growAndRehash();
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)this.set.remove((long)(100 + i)));
        }
        Assertions.assertEquals((int)8, (int)this.set.size());
        ((MutableLinearProbeLongHashSet)Mockito.verify((Object)this.set)).rehashWithoutGrow();
        ((MutableLinearProbeLongHashSet)Mockito.verify((Object)this.set, (VerificationMode)Mockito.never())).growAndRehash();
    }

    @Test
    void forEach() {
        LongProcedure consumer = (LongProcedure)Mockito.mock(LongProcedure.class);
        this.set.addAll(new long[]{1L, 2L, 100L, 200L});
        this.set.forEach(consumer);
        ((LongProcedure)Mockito.verify((Object)consumer)).accept(ArgumentMatchers.eq((long)1L));
        ((LongProcedure)Mockito.verify((Object)consumer)).accept(ArgumentMatchers.eq((long)2L));
        ((LongProcedure)Mockito.verify((Object)consumer)).accept(ArgumentMatchers.eq((long)100L));
        ((LongProcedure)Mockito.verify((Object)consumer)).accept(ArgumentMatchers.eq((long)200L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    void allocateFreeMemory() {
        MemoryTracker memoryTrackerSpy = (MemoryTracker)Mockito.spy((Object)new LocalMemoryTracker());
        MutableLinearProbeLongHashSet set2 = new MutableLinearProbeLongHashSet((MemoryAllocator)new OffHeapMemoryAllocator((OffHeapBlockAllocator)this.blockAllocator), memoryTrackerSpy);
        ((MemoryTracker)Mockito.verify((Object)memoryTrackerSpy)).allocateNative(ArgumentMatchers.anyLong());
        for (int i = 0; i < 32; ++i) {
            set2.add((long)(100 + i));
        }
        ((MemoryTracker)Mockito.verify((Object)memoryTrackerSpy)).releaseNative(ArgumentMatchers.anyLong());
        ((MemoryTracker)Mockito.verify((Object)memoryTrackerSpy, (VerificationMode)Mockito.times((int)2))).allocateNative(ArgumentMatchers.anyLong());
        set2.close();
        ((MemoryTracker)Mockito.verify((Object)memoryTrackerSpy, (VerificationMode)Mockito.times((int)2))).releaseNative(ArgumentMatchers.anyLong());
    }

    @Test
    void freeFrozenMemory() {
        MemoryTracker memoryTrackerSpy = (MemoryTracker)Mockito.spy((Object)new LocalMemoryTracker());
        MutableLinearProbeLongHashSet set2 = new MutableLinearProbeLongHashSet((MemoryAllocator)new OffHeapMemoryAllocator((OffHeapBlockAllocator)this.blockAllocator), memoryTrackerSpy);
        ((MemoryTracker)Mockito.verify((Object)memoryTrackerSpy)).allocateNative(ArgumentMatchers.anyLong());
        set2.addAll(new long[]{100L, 200L, 300L});
        set2.freeze();
        set2.remove(100L);
        set2.freeze();
        set2.clear();
        set2.close();
        ((MemoryTracker)Mockito.verify((Object)memoryTrackerSpy, (VerificationMode)Mockito.times((int)3))).releaseNative(ArgumentMatchers.anyLong());
    }

    @Test
    void toList() {
        Assertions.assertEquals((int)0, (int)this.set.toList().size());
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{1L, 2L, 3L, 100L, 200L, 300L}), (Object)this.set.toList().sortThis());
    }

    @Test
    void toArray() {
        Assertions.assertEquals((int)0, (int)this.set.toArray().length);
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 100L, 200L, 300L}, (long[])this.set.toSortedArray());
    }

    @Test
    void emptyIterator() {
        MutableLongIterator iterator = this.set.longIterator();
        Assertions.assertFalse(() -> ((MutableLongIterator)iterator).hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((MutableLongIterator)iterator).next());
    }

    @Test
    void iterator() {
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        MutableLongIterator iterator = this.set.longIterator();
        LongHashSet visited = new LongHashSet();
        while (iterator.hasNext()) {
            visited.add(iterator.next());
        }
        Assertions.assertEquals((int)6, (int)visited.size());
        Assertions.assertEquals((Object)this.set, (Object)visited);
        Assertions.assertThrows(NoSuchElementException.class, () -> ((MutableLongIterator)iterator).next());
    }

    @Test
    void freeze() {
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        LongSet frozen = this.set.freeze();
        Assertions.assertEquals((Object)this.set, (Object)frozen);
        Assertions.assertEquals((int)6, (int)this.set.size());
        Assertions.assertEquals((int)6, (int)frozen.size());
        this.set.removeAll(new long[]{1L, 100L});
        Assertions.assertNotEquals((Object)this.set, (Object)frozen);
        Assertions.assertEquals((int)4, (int)this.set.size());
        Assertions.assertEquals((int)6, (int)frozen.size());
    }

    @Test
    void testEquals() {
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        MutableLinearProbeLongHashSet set2 = new MutableLinearProbeLongHashSet(this.memoryAllocator, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        set2.addAll(new long[]{300L, 200L, 100L, 3L, 2L, 1L});
        LongHashSet set3 = LongHashSet.newSetWith((long[])new long[]{300L, 200L, 100L, 3L, 2L, 1L});
        Assertions.assertEquals((Object)this.set, (Object)set2);
        Assertions.assertEquals((Object)this.set, (Object)set3);
        this.set.removeAll(new long[]{1L, 100L});
        Assertions.assertNotEquals((Object)this.set, (Object)set2);
        Assertions.assertNotEquals((Object)this.set, (Object)set3);
        set2.close();
    }

    @Test
    void frozenIterator() {
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        LongIterator iter1 = this.set.freeze().longIterator();
        this.set.removeAll(new long[]{1L, 100L});
        LongIterator iter2 = this.set.freeze().longIterator();
        this.set.removeAll(new long[]{2L, 200L});
        LongSet values1 = MutableLinearProbeLongHashSetTest.drain(iter1);
        LongSet values2 = MutableLinearProbeLongHashSetTest.drain(iter2);
        Assertions.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L, 100L, 200L, 300L}), (Object)values1);
        Assertions.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{2L, 3L, 200L, 300L}), (Object)values2);
    }

    @Test
    void frozenIteratorFailsWhenParentSetIsClosed() {
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        LongIterator iter = this.set.freeze().longIterator();
        this.set.close();
        Assertions.assertThrows(ConcurrentModificationException.class, () -> ((LongIterator)iter).hasNext());
        Assertions.assertThrows(ConcurrentModificationException.class, () -> ((LongIterator)iter).next());
    }

    @Test
    void allSatisfy() {
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        Assertions.assertTrue((boolean)this.set.allSatisfy((LongPredicate & Serializable)x -> x < 1000L));
        Assertions.assertFalse((boolean)this.set.allSatisfy((LongPredicate & Serializable)x -> x % 2L == 0L));
    }

    @Test
    void noneSatisfy() {
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        Assertions.assertTrue((boolean)this.set.noneSatisfy((LongPredicate & Serializable)x -> x < 0L));
        Assertions.assertFalse((boolean)this.set.noneSatisfy((LongPredicate & Serializable)x -> x % 2L == 0L));
    }

    @Test
    void anySatisfy() {
        this.set.addAll(new long[]{1L, 2L, 3L, 100L, 200L, 300L});
        Assertions.assertTrue((boolean)this.set.anySatisfy((LongPredicate & Serializable)x -> x % 3L == 1L));
        Assertions.assertFalse((boolean)this.set.anySatisfy((LongPredicate & Serializable)x -> x < 0L));
    }

    @Test
    void randomizedTest() {
        long[] values;
        int count = 10000 + this.rnd.nextInt(1000);
        LongHashSet uniqueValues = new LongHashSet();
        while (uniqueValues.size() < count) {
            uniqueValues.add(this.rnd.nextLong());
        }
        for (long v2 : values = uniqueValues.toArray()) {
            Assertions.assertTrue((boolean)this.set.add(v2));
        }
        ArrayUtils.shuffle((long[])values);
        for (long v2 : values) {
            Assertions.assertTrue((boolean)this.set.contains(v2));
            Assertions.assertFalse((boolean)this.set.add(v2));
        }
        Assertions.assertTrue((boolean)this.set.containsAll(values));
        long[] toRemove = uniqueValues.select((LongPredicate & Serializable)v -> this.rnd.nextInt(100) < 75).toArray();
        ArrayUtils.shuffle((long[])toRemove);
        for (long v3 : toRemove) {
            Assertions.assertTrue((boolean)this.set.remove(v3));
            Assertions.assertFalse((boolean)this.set.contains(v3));
        }
        Assertions.assertEquals((int)(count - toRemove.length), (int)this.set.size());
    }

    private static LongSet drain(LongIterator iter) {
        LongHashSet result = new LongHashSet();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    @Nested
    class IterationConcurrentModification {
        IterationConcurrentModification() {
        }

        @Test
        void add() {
            this.testIteratorFails(s -> s.add(0L), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.add(1L), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.add(0L), 1L, 2L, 3L);
            this.testIteratorFails(s -> s.add(1L), 0L, 2L, 3L);
            this.testIteratorFails(s -> s.add(2L), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.add(4L), 0L, 1L, 2L, 3L);
        }

        @Test
        void remove() {
            this.testIteratorFails(s -> s.remove(0L), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.remove(1L), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.remove(2L), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.remove(4L), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.removeAll((LongIterable)LongSets.immutable.empty()), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.removeAll(ArrayUtils.EMPTY_LONG_ARRAY), 0L, 1L, 2L, 3L);
        }

        @Test
        void addAll() {
            this.testIteratorFails(s -> s.addAll(new long[]{0L, 2L}), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.addAll(new long[]{4L, 5L}), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.addAll((LongIterable)LongSets.immutable.of(new long[]{0L, 2L})), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.addAll((LongIterable)LongSets.immutable.of(new long[]{4L, 5L})), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.addAll((LongIterable)LongSets.immutable.empty()), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.addAll(ArrayUtils.EMPTY_LONG_ARRAY), 0L, 1L, 2L, 3L);
        }

        @Test
        void removeAll() {
            this.testIteratorFails(s -> s.removeAll(new long[]{0L, 2L}), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.removeAll(new long[]{4L, 5L}), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.removeAll((LongIterable)LongSets.immutable.of(new long[]{0L, 2L})), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.removeAll((LongIterable)LongSets.immutable.of(new long[]{4L, 5L})), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.removeAll((LongIterable)LongSets.immutable.empty()), 0L, 1L, 2L, 3L);
            this.testIteratorFails(s -> s.removeAll(ArrayUtils.EMPTY_LONG_ARRAY), 0L, 1L, 2L, 3L);
        }

        @Test
        void clear() {
            this.testIteratorFails(MutableLinearProbeLongHashSet::clear, 1L, 2L, 3L);
        }

        @Test
        void close() {
            this.testIteratorFails(MutableLinearProbeLongHashSet::close, 1L, 2L, 3L);
        }

        private void testIteratorFails(Consumer<MutableLinearProbeLongHashSet> mutator, long ... initialValues) {
            MutableLinearProbeLongHashSetTest.this.set.addAll(initialValues);
            MutableLongIterator iterator = MutableLinearProbeLongHashSetTest.this.set.longIterator();
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertDoesNotThrow(() -> ((MutableLongIterator)iterator).next());
            mutator.accept(MutableLinearProbeLongHashSetTest.this.set);
            Assertions.assertThrows(ConcurrentModificationException.class, () -> ((MutableLongIterator)iterator).hasNext());
            Assertions.assertThrows(ConcurrentModificationException.class, () -> ((MutableLongIterator)iterator).next());
        }
    }

    @Nested
    class Collisions {
        private final ImmutableLongList collisions = this.generateCollisions(5);
        private final long a = this.collisions.get(0);
        private final long b = this.collisions.get(1);
        private final long c = this.collisions.get(2);
        private final long d = this.collisions.get(3);
        private final long e = this.collisions.get(4);

        Collisions() {
        }

        private ImmutableLongList generateCollisions(int n) {
            MutableLongList elements;
            long seed = MutableLinearProbeLongHashSetTest.this.rnd.nextLong();
            try (MutableLinearProbeLongHashSet s = new MutableLinearProbeLongHashSet(MutableLinearProbeLongHashSetTest.this.memoryAllocator, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                long v;
                for (v = (long)s.hashAndMask(seed); s.hashAndMask(v) != 0 || v == 0L || v == 1L; ++v) {
                }
                int h = s.hashAndMask(v);
                elements = LongLists.mutable.with(new long[]{v});
                while (elements.size() < n) {
                    if (s.hashAndMask(++v) != h) continue;
                    elements.add(v);
                }
            }
            return elements.toImmutable();
        }

        @Test
        void addAll() {
            MutableLinearProbeLongHashSetTest.this.set.addAll((LongIterable)this.collisions);
            Assertions.assertEquals((Object)this.collisions, (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void addAllReversed() {
            MutableLinearProbeLongHashSetTest.this.set.addAll((LongIterable)this.collisions.toReversed());
            Assertions.assertEquals((Object)this.collisions.toReversed(), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void addAllRemoveLast() {
            MutableLinearProbeLongHashSetTest.this.set.addAll((LongIterable)this.collisions);
            MutableLinearProbeLongHashSetTest.this.set.remove(this.e);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.b, this.c, this.d}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void addAllRemoveFirst() {
            MutableLinearProbeLongHashSetTest.this.set.addAll((LongIterable)this.collisions);
            MutableLinearProbeLongHashSetTest.this.set.remove(this.a);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.b, this.c, this.d, this.e}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void addAllRemoveMiddle() {
            MutableLinearProbeLongHashSetTest.this.set.addAll((LongIterable)this.collisions);
            MutableLinearProbeLongHashSetTest.this.set.removeAll(new long[]{this.b, this.d});
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c, this.e}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void addAllRemoveMiddle2() {
            MutableLinearProbeLongHashSetTest.this.set.addAll((LongIterable)this.collisions);
            MutableLinearProbeLongHashSetTest.this.set.removeAll(new long[]{this.a, this.c, this.e});
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.b, this.d}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void addReusesRemovedHead() {
            MutableLinearProbeLongHashSetTest.this.set.addAll(new long[]{this.a, this.b, this.c});
            MutableLinearProbeLongHashSetTest.this.set.remove(this.a);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.b, this.c}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
            MutableLinearProbeLongHashSetTest.this.set.add(this.d);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.d, this.b, this.c}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void addReusesRemovedTail() {
            MutableLinearProbeLongHashSetTest.this.set.addAll(new long[]{this.a, this.b, this.c});
            MutableLinearProbeLongHashSetTest.this.set.remove(this.c);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.b}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
            MutableLinearProbeLongHashSetTest.this.set.add(this.d);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.b, this.d}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void addReusesRemovedMiddle() {
            MutableLinearProbeLongHashSetTest.this.set.addAll(new long[]{this.a, this.b, this.c});
            MutableLinearProbeLongHashSetTest.this.set.remove(this.b);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
            MutableLinearProbeLongHashSetTest.this.set.add(this.d);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.d, this.c}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void addReusesRemovedMiddle2() {
            MutableLinearProbeLongHashSetTest.this.set.addAll(new long[]{this.a, this.b, this.c, this.d, this.e});
            MutableLinearProbeLongHashSetTest.this.set.removeAll(new long[]{this.b, this.c});
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.d, this.e}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
            MutableLinearProbeLongHashSetTest.this.set.addAll(new long[]{this.c, this.b});
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c, this.b, this.d, this.e}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }

        @Test
        void rehashingCompactsSparseSentinels() {
            MutableLinearProbeLongHashSetTest.this.set.addAll(new long[]{this.a, this.b, this.c, this.d, this.e});
            MutableLinearProbeLongHashSetTest.this.set.removeAll(new long[]{this.b, this.d, this.e});
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
            MutableLinearProbeLongHashSetTest.this.set.addAll(new long[]{this.b, this.d, this.e});
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.b, this.c, this.d, this.e}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
            MutableLinearProbeLongHashSetTest.this.set.removeAll(new long[]{this.b, this.d, this.e});
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
            MutableLinearProbeLongHashSetTest.this.set.rehashWithoutGrow();
            MutableLinearProbeLongHashSetTest.this.set.addAll(new long[]{this.e, this.d, this.b});
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c, this.e, this.d, this.b}), (Object)MutableLinearProbeLongHashSetTest.this.set.toList());
        }
    }
}

