/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Iterator;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.collection.LongProbeTable;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;

class LongProbeTableTest {
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final LongProbeTable<LongValue> table = LongProbeTable.createLongProbeTable((MemoryTracker)this.memoryTracker);

    LongProbeTableTest() {
    }

    @AfterEach
    void tearDown() {
        this.table.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void emptySize() {
        long actual = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actual, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void countInternalStructure() {
        this.table.put(2L, (Measurable)Values.longValue((long)1L));
        this.table.put(2L, (Measurable)Values.longValue((long)2L));
        this.table.put(3L, (Measurable)Values.longValue((long)3L));
        long itemSize = this.meter.measure((Object)1L) * 3L;
        long actualSize = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actualSize, (long)this.memoryTracker.estimatedHeapMemory());
        Iterator iterator2 = this.table.get(2L);
        Assertions.assertTrue((boolean)iterator2.hasNext());
        Assertions.assertEquals((long)1L, (long)((LongValue)iterator2.next()).longValue());
        Assertions.assertTrue((boolean)iterator2.hasNext());
        Assertions.assertEquals((long)2L, (long)((LongValue)iterator2.next()).longValue());
        Assertions.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = this.table.get(3L);
        Assertions.assertTrue((boolean)iterator3.hasNext());
        Assertions.assertEquals((long)3L, (long)((LongValue)iterator3.next()).longValue());
        Assertions.assertFalse((boolean)iterator3.hasNext());
    }

    @Test
    void closeShouldReleaseEverything() {
        long externalAllocation = 113L;
        this.memoryTracker.allocateHeap(externalAllocation);
        this.table.put(2L, (Measurable)Values.longValue((long)1L));
        this.table.put(2L, (Measurable)Values.longValue((long)2L));
        this.table.put(3L, (Measurable)Values.longValue((long)3L));
        long itemSize = this.meter.measure((Object)1L) * 3L;
        long actualSize = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)(actualSize + externalAllocation), (long)this.memoryTracker.estimatedHeapMemory());
        this.table.close();
        Assertions.assertEquals((long)externalAllocation, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.releaseHeap(externalAllocation);
    }
}

