/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class ConvertersTest {
    @Inject
    private TestDirectory directory;

    ConvertersTest() {
    }

    @Test
    void shouldSortFilesByNumberCleverly() throws Exception {
        File file1 = this.existenceOfFile("file1");
        File file123 = this.existenceOfFile("file123");
        File file12 = this.existenceOfFile("file12");
        File file2 = this.existenceOfFile("file2");
        File file32 = this.existenceOfFile("file32");
        Object[] files = (File[])Converters.regexFiles((boolean)true).apply(this.directory.file("file.*", new String[0]).getAbsolutePath());
        Assertions.assertArrayEquals((Object[])new File[]{file1, file2, file12, file32, file123}, (Object[])files);
    }

    private File existenceOfFile(String name) throws IOException {
        File file = this.directory.file(name, new String[0]);
        Assertions.assertTrue((boolean)file.createNewFile());
        return file;
    }
}

